/*
The current (2014-05-20) strategy is:
1.  Reset when 10 HC or 25 % of current HC, whichever is higher, is reached,
    until Kitten managers bought, after which go for 100 % of current HC, until
    Nanocosmics bought, after which go for 115 % until Glow-in-the-dark bought,
    after which go for 125 %. Don't buy One mind until 5000 HC gained (or base
    season is Halloween).
2.  When 5000 HC reached, go for Neverclick (1 million with just 15 big cookie
    clicks). After Neverclick reached, Reset.
3.  Resume HC percentage hunt as before, enter Grandmapocalypse, during which:
    a)  Make sure it's Halloween.
    b)  Pop wrinklers as soon as they appear, except during frenzies, until
        "Spooky cookies" and "Moistburster" won, after which only pop wrinklers
        when it enables a purchase to be made.
    c)  Buy researched upgrades as soon as possible until Pledge reached.
    d)  After b) + c): buy Pledge, then Covenant, then Revoke Covenant; repeat
        until all related achievements won, after which remain at Pledge.
    e)  Reset after required HC percentage reached.
4.  Speed through Grandmapocalypse on succeeding rounds, only buy Pledge
    repeatedly (never Covenant) and only pop wrinklers when it enables a
    purchase to be made.
5.  Stay in Valentine's until "Lovely cookies" won. Switch to Christmas and stay
    until exhausted. Switch to Easter and stay until exhausted. Switch back to
    Christmas and stay.
*/
var Audio, Beautify, Game, console, choose, numberFormatters;
var Cheetah = {};

Cheetah.tweakables = {

    // speedy click (like in frenzy) when cookies in bank less than this
    bigCookieClickLimit: 1000,

    intervals: { // ms
        bigClick: {
            normal: 1000,
            duringFrenzy: 50
        }
    }
};



(function () {
    "use strict";
    var i, name;
    for (i = 0; i < Game.ObjectsById.length; i += 1) {
        name = Game.ObjectsById[i].name;
        if (name.substr(0, 1) === "A") {
            Game.ObjectsById[i].articledName = "an " + name;
        } else {
            Game.ObjectsById[i].articledName = "a " + name;
        }
    }
}());



Cheetah.config = {

    // reset automatically once proper amount of HC gained
    autoReset: true,
    autoResetHcGainLimit: {
        minimum: 10,    // absolute number

        // http://ur1.ca/h565u
        percent: function () {
            "use strict";
            if (Game.Upgrades["Glow-in-the-dark"].bought) {
                return 100;
            }
            if (Game.Upgrades.Nanocosmics.bought) {
                return 75;
            }
            if (Game.Upgrades["Kitten managers"].bought) {
                return 50;
            }
            return 25;
        }
    },

    bigCookieClickLimit: Cheetah.tweakables.bigCookieClickLimit,

    clickRedCookies: true,

    clicksPerSecond: {
        normal: 1000 / Cheetah.tweakables.intervals.bigClick.normal,
        duringFrenzy: 1000 / Cheetah.tweakables.intervals.bigClick.duringFrenzy
    },

    // how many common eggs remaining unlocked shall mean I should abandon
    // Easter. ignored if not all egg achievements have been won yet, or if any
    // good rare eggs also remain unlocked.
    // I believe the jury is still (Cheetah.constants.compatibleGameVersion)
    // out on how much this should be.
    // http://www.reddit.com/r/CookieClicker/comments/25su0v/christmas_vs_easter/chkyq8z
    eggCutOff: 0,

    intervals: { // ms
        bigClick: {
            normal: Cheetah.tweakables.intervals.bigClick.normal,
            duringFrenzy: Cheetah.tweakables.intervals.bigClick.duringFrenzy
        },
        update: 250,
        tickerTime: 1000
    },

    // how long to wait for attainable goals to get reached before resetting.
    // in other words, if a reset would otherwise be imminent, and a goal is
    // reachable within time set here, hold off resetting until goal is reached.
    // being tested independently each cycle, and with multiple goals, this may
    // stack up: if another goal becomes reachable during first wait, the reset
    // will be pushed further out into future.
    reasonableWaitingTime: 5 * 60, // seconds

    selection: {
        ageLimit: 2500 // ms
    }
};



Cheetah.constants = {
    achievements: {

        // main.js:6087 (Cheetah.constants.compatibleGameVersion)
        click: [
            "Clicktastic",
            "Clickathlon",
            "Clickolympics",
            "Clickorama",
            "Clickasmic",
            "Clickageddon",
            "Clicknarok"
        ],

        elder: {
            "Elder nap": function () {
                "use strict";
                return Game.Upgrades["Elder Pledge"].getPrice();
            },
            "Elder slumber": function () {
                "use strict";
                var i, n, p;

                n = 5 - Game.pledges;

                p = 0;
                for (i = 4; 5 - i <= n; i -= 1) {
                    p += Math.pow(8, Math.min(Game.pledges + i + 2, 14));
                }

                return p;
            },
            "Elder calm": function () {
                "use strict";
                return Game.Upgrades["Elder Covenant"].getPrice();
            }
        },

        haveObjects: {
            anyType: {
                list: [
                    "Builder",
                    "Architect",
                    "Engineer",
                    "Lord of Constructs"
                ],
                objectsNeeded: [100, 400, 800, 1500]
            },

            oneType: [
                {
                    list: [
                        "Click",
                        "Double-click",
                        "Mouse wheel",
                        "Of Mice and Men",
                        "The Digital",
                        "Extreme polydactyly",
                        "Dr. T"
                    ],
                    objectsNeeded: [1, 2, 50, 100, 200, 300, 400]
                },
                {
                    list: [
                        "Grandma's cookies",
                        "Sloppy kisses",
                        "Retirement home",
                        "Friend of the ancients",
                        "Ruler of the ancients",
                        "The old never bothered me anyway"
                    ],
                    objectsNeeded: [1, 50, 100, 150, 200, 250]
                },
                {
                    list: [
                        "My first farm",
                        "Reap what you sow",
                        "Farm ill",
                        "Perfected agriculture",
                        "Homegrown"
                    ],
                    objectsNeeded: [1, 50, 100, 150, 200]
                },
                {
                    list: [
                        "Production chain",
                        "Industrial revolution",
                        "Global warming",
                        "Ultimate automation",
                        "Technocracy"
                    ],
                    objectsNeeded: [1, 50, 100, 150, 200]
                },
                {
                    list: [
                        "You know the drill",
                        "Excavation site",
                        "Hollow the planet",
                        "Can you dig it",
                        "The center of the Earth"
                    ],
                    objectsNeeded: [1, 50, 100, 150, 200]
                },
                {
                    list: [
                        "Expedition",
                        "Galactic highway",
                        "Far far away",
                        "Type II civilization",
                        "We come in peace"
                    ],
                    objectsNeeded: [1, 50, 100, 150, 200]
                },
                {
                    list: [
                        "Transmutation",
                        "Transmogrification",
                        "Gold member",
                        "Gild wars",
                        "The secrets of the universe"
                    ],
                    objectsNeeded: [1, 50, 100, 150, 200]
                },
                {
                    list: [
                        "A whole new world",
                        "Now you're thinking",
                        "Dimensional shift",
                        "Brain-split",
                        "Realm of the Mad God"
                    ],
                    objectsNeeded: [1, 50, 100, 150, 200]
                },
                {
                    list: [
                        "Time warp",
                        "Alternate timeline",
                        "Rewriting history",
                        "Time duke",
                        "Forever and ever"
                    ],
                    objectsNeeded: [1, 50, 100, 150, 200]
                },
                {
                    list: [
                        "Antibatter",
                        "Quirky quarks",
                        "It does matter!",
                        "Molecular maestro",
                        "Walk the planck"
                    ],
                    objectsNeeded: [1, 50, 100, 150, 200]
                },
                {
                    list: [
                        "Lone photon",
                        "Dazzling glimmer",
                        "Blinding flash",
                        "Unending glow",
                        "Rise and shine"
                    ],
                    objectsNeeded: [1, 50, 100, 150, 200]
                }
            ],

            special: {
                "One with everything": function () {
                    "use strict";
                    return 1;
                },
                "Mathematician": function (i) {
                    "use strict";
                    i = Game.ObjectsById.length - i - 1;
                    return Math.min(128, Math.pow(2, i));
                },
                "Base 10": function (i) {
                    "use strict";
                    return Game.ObjectsById.length - i * 10;
                },
                "Centennial": function () {
                    "use strict";
                    return 100;
                },
                "Centennial and a half": function () {
                    "use strict";
                    return 150;
                },
                "Bicentennial": function () {
                    "use strict";
                    return 200;
                }
            }
        },

        // main.js:6142 (Cheetah.constants.compatibleGameVersion)
        objectMade: {
            cookiesNeeded: [
                1000000000000 * 1000000,
                1000000000000 * 1000000,
                1000000000000,
                1000000000000 * 10,
                1000000000000 * 100,
                1000000000000 * 1000,
                1000000000000 * 10000,
                1000000000000 * 100000,
                1000000000000 * 1000000,
                1000000000000 * 10000000,
                1000000000000 * 100000000
            ],
            list: [
                "Click delegator",
                "Gushing grannies",
                "I hate manure",
                "The incredible machine",
                "Never dig down",
                "And beyond",
                "Magnum Opus",
                "With strange eons",
                "Spacetime jigamaroo",
                "Supermassive",
                "Praise the sun"
            ]
        },

        resetWith: [
            "Sacrifice",
            "Oblivion",
            "From scratch",
            "Nihilism",
            "Dematerialize",
            "Nil zero zilch",
            "Transcendence",
            "Obliterate"
        ],

        santa: {
            "Coming to town": 6,
            "All hail Santa": 14
        }
    },

    compatibleGameVersion: 1.0465,

    css: {
        styleSheet: document.styleSheets[1]
    },

    elements: {
        bakeryNameInput: {
            id: "bakeryNameInput"
        }
    },

    functions: {
        // Cheetah.constants.compatibleGameVersion
        game: {
            loadSave: Game.LoadSave,
            logic: Game.Logic,
            loop: Game.Loop,
            notify: Game.Notify,
            popup: Game.Popup,
            reset: Game.Reset
        }
    },

    objects: {
        cursor: Game.ObjectsById[0],
        grandma: Game.ObjectsById[1],
        farm: Game.ObjectsById[2],
        factory: Game.ObjectsById[3],
        mine: Game.ObjectsById[4],
        shipment: Game.ObjectsById[5],
        alchemyLab: Game.ObjectsById[6],
        portal: Game.ObjectsById[7],
        timeMachine: Game.ObjectsById[8],
        antimatterCondenser: Game.ObjectsById[9],
        prism: Game.ObjectsById[10]
    },

    // these set the amounts of object each upgrade requires. arrays [a, b] are
    // interpreted as "buy b of object whose id = a (instead of the object the
    // upgrade is associated to)"
    objectUpgrades: [
        {
            reinforcedIndexFinger: 1,
            carpalTunnelPreventionCream: 1,
            ambidextrous: 10,
            thousandFingers: 20,
            millionFingers: 40,
            billionFingers: 80,
            trillionFingers: 120,
            quadrillionFingers: 160,
            quintillionFingers: 200,
            sextillionFingers: 240,
            septillionFingers: 280,
            octillionFingers: 320
        },
        {
            farmerGrandmas: [2, 15],
            workerGrandmas: [3, 15],
            minerGrandmas: [4, 15],
            cosmicGrandmas: [5, 15],
            transmutedGrandmas: [6, 15],
            alteredGrandmas: [7, 15],
            grandmasGrandmas: [8, 15],
            antiGrandmas: [9, 15],
            rainbowGrandmas: [10, 15],
            forwardsFromGrandma: 1,
            steelPlatedRollingPins: 1,
            lubricatedDentures: 10,
            pruneJuice: 50,
            doubleThickGlasses: 100,
            agingAgents: 200
        },
        {
            cheapHoes: 1,
            fertilizer: 1,
            cookieTrees: 10,
            geneticallyModifiedCookies: 50,
            gingerbreadScarecrows: 100,
            pulsarSprinklers: 200
        },
        {
            sturdierConveyorBelts: 1,
            childLabor: 1,
            sweatshop: 10,
            radiumReactors: 50,
            recombobulators: 100,
            deepBakeProcess: 200
        },
        {
            sugarGas: 1,
            megaDrill: 1,
            ultradrill: 10,
            ultimadrill: 50,
            hBombMining: 100,
            coreforge: 200
        },
        {
            vanillaNebulae: 1,
            wormholes: 1,
            frequentFlyer: 10,
            warpDrive: 50,
            chocolateMonoliths: 100,
            generationShip: 200
        },
        {
            antimony: 1,
            essenceOfDough: 1,
            trueChocolate: 10,
            ambrosia: 50,
            aquaCrustulae: 100,
            originCrucible: 200
        },
        {
            ancientTablet: 1,
            insaneOatlingWorkers: 1,
            soulBond: 10,
            sanityDance: 50,
            braneTransplant: 100,
            deitySizedPortals: 200
        },
        {
            fluxCapacitors: 1,
            timeParadoxResolver: 1,
            quantumConundrum: 10,
            causalityEnforcer: 50,
            yestermorrowComparators: 100,
            farFutureEnactment: 200
        },
        {
            sugarBosons: 1,
            stringTheory: 1,
            largeMacaronCollider: 10,
            bigBangBake: 50,
            reverseCyclotrons: 100,
            nanocosmics: 200
        },
        {
            gemPolish: 1,
            ninthColor: 1,
            chocolateLight: 10,
            grainbow: 50,
            pureCosmicLight: 100,
            glowInTheDark: 200
        }
    ],

    locale: {
        date: {
            hour: "2-digit",
            minute: "2-digit",
            second: "2-digit"
        }
    },

    luckyBankMultiplier: 12000,

    saveName: "Cheetah (for Cookie Clicker) save. jani@mummila.net",

    // season names are indexed in Game.seasons, but indexing them manually here
    // instead of copying them from Game lets the code fall back slightly safer
    // when a new Game version comes out (as new seasons have not yet been
    // implemented here).
    // main.js:4717 (Cheetah.constants.compatibleGameVersion)
    seasons: [
        "easter",
        "halloween",
        "christmas",
        "valentines",
        "fools"
    ],

    tags: {
        span: {
            openRed: "<span style=\"color:#f33 !important;\">",
            closeRed: "</span>"
        }
    },

    santaLevels: Game.santaLevels.length - 1,

    upgrades: {
        oneMind: Game.UpgradesById[69],
        exoticNuts: Game.UpgradesById[70],
        communalBrainsweep: Game.UpgradesById[71],
        arcaneSugar: Game.UpgradesById[72],
        elderPact: Game.UpgradesById[73],
        elderPledge: Game.UpgradesById[74],
        elderCovenant: Game.UpgradesById[84],
        sacrificialRollingPins: Game.UpgradesById[87],
        revokeElderCovenant: Game.UpgradesById[85],
        persistentMemory: Game.UpgradesById[141],

        luckyDay: Game.UpgradesById[52],
        serendipity: Game.UpgradesById[53],
        getLucky: Game.UpgradesById[86],

        aFestiveHat: Game.UpgradesById[152],
        increasedMerriness: Game.UpgradesById[153],
        improvedJolliness: Game.UpgradesById[154],
        aLumpOfCoal: Game.UpgradesById[155],
        anItchySweater: Game.UpgradesById[156],
        reindeerBakingGrounds: Game.UpgradesById[157],
        weightedSleighs: Game.UpgradesById[158],
        hoHoHoFlavoredFrosting: Game.UpgradesById[159],
        seasonSavings: Game.UpgradesById[160],
        toyWorkshop: Game.UpgradesById[161],
        naughtyList: Game.UpgradesById[162],
        santasBottomlessBag: Game.UpgradesById[163],
        santasHelpers: Game.UpgradesById[164],
        santasLegacy: Game.UpgradesById[165],
        santasMilkAndCookies: Game.UpgradesById[166],

        eggs: {
            chicken: Game.UpgradesById[210],
            duck: Game.UpgradesById[211],
            turkey: Game.UpgradesById[212],
            quail: Game.UpgradesById[213],
            robin: Game.UpgradesById[214],
            ostrich: Game.UpgradesById[215],
            cassowary: Game.UpgradesById[216],
            salmonRoe: Game.UpgradesById[217],
            frogspawn: Game.UpgradesById[218],
            shark: Game.UpgradesById[219],
            turtle: Game.UpgradesById[220],
            antLarva: Game.UpgradesById[221],
            goldenGoose: Game.UpgradesById[222],
            faberge: Game.UpgradesById[223],
            wrinklerspawn: Game.UpgradesById[224],
            cookie: Game.UpgradesById[225],
            omelette: Game.UpgradesById[226],
            chocolate: Game.UpgradesById[227],
            century: Game.UpgradesById[228],
            egg: Game.UpgradesById[229]
        },

        seasonSwitcher: Game.UpgradesById[181],
        bunnyBiscuit: Game.UpgradesById[209],
        festiveBiscuit: Game.UpgradesById[182],
        foolsBiscuit: Game.UpgradesById[185],
        ghostlyBiscuit: Game.UpgradesById[183],
        lovesickBiscuit: Game.UpgradesById[184],

        reinforcedIndexFinger: Game.UpgradesById[0],
        carpalTunnelPreventionCream: Game.UpgradesById[1],
        ambidextrous: Game.UpgradesById[2],
        thousandFingers: Game.UpgradesById[3],
        millionFingers: Game.UpgradesById[4],
        billionFingers: Game.UpgradesById[5],
        trillionFingers: Game.UpgradesById[6],
        quadrillionFingers: Game.UpgradesById[43],
        quintillionFingers: Game.UpgradesById[82],
        sextillionFingers: Game.UpgradesById[109],
        septillionFingers: Game.UpgradesById[188],
        octillionFingers: Game.UpgradesById[189],

        forwardsFromGrandma: Game.UpgradesById[7],
        steelPlatedRollingPins: Game.UpgradesById[8],
        lubricatedDentures: Game.UpgradesById[9],
        pruneJuice: Game.UpgradesById[44],
        doubleThickGlasses: Game.UpgradesById[110],
        agingAgents: Game.UpgradesById[192],
        farmerGrandmas: Game.UpgradesById[57],
        workerGrandmas: Game.UpgradesById[58],
        minerGrandmas: Game.UpgradesById[59],
        cosmicGrandmas: Game.UpgradesById[60],
        transmutedGrandmas: Game.UpgradesById[61],
        alteredGrandmas: Game.UpgradesById[62],
        grandmasGrandmas: Game.UpgradesById[63],
        antiGrandmas: Game.UpgradesById[103],
        rainbowGrandmas: Game.UpgradesById[180],

        cheapHoes: Game.UpgradesById[10],
        fertilizer: Game.UpgradesById[11],
        cookieTrees: Game.UpgradesById[12],
        geneticallyModifiedCookies: Game.UpgradesById[45],
        gingerbreadScarecrows: Game.UpgradesById[111],
        pulsarSprinklers: Game.UpgradesById[193],

        sturdierConveyorBelts: Game.UpgradesById[13],
        childLabor: Game.UpgradesById[14],
        sweatshop: Game.UpgradesById[15],
        radiumReactors: Game.UpgradesById[46],
        recombobulators: Game.UpgradesById[112],
        deepBakeProcess: Game.UpgradesById[194],

        sugarGas: Game.UpgradesById[16],
        megaDrill: Game.UpgradesById[17],
        ultradrill: Game.UpgradesById[18],
        ultimadrill: Game.UpgradesById[47],
        hBombMining: Game.UpgradesById[113],
        coreforge: Game.UpgradesById[195],

        vanillaNebulae: Game.UpgradesById[19],
        wormholes: Game.UpgradesById[20],
        frequentFlyer: Game.UpgradesById[21],
        warpDrive: Game.UpgradesById[48],
        chocolateMonoliths: Game.UpgradesById[114],
        generationShip: Game.UpgradesById[196],

        antimony: Game.UpgradesById[22],
        essenceOfDough: Game.UpgradesById[23],
        trueChocolate: Game.UpgradesById[24],
        ambrosia: Game.UpgradesById[49],
        aquaCrustulae: Game.UpgradesById[115],
        originCrucible: Game.UpgradesById[197],

        ancientTablet: Game.UpgradesById[25],
        insaneOatlingWorkers: Game.UpgradesById[26],
        soulBond: Game.UpgradesById[27],
        sanityDance: Game.UpgradesById[50],
        braneTransplant: Game.UpgradesById[116],
        deitySizedPortals: Game.UpgradesById[198],

        fluxCapacitors: Game.UpgradesById[28],
        timeParadoxResolver: Game.UpgradesById[29],
        quantumConundrum: Game.UpgradesById[30],
        causalityEnforcer: Game.UpgradesById[51],
        yestermorrowComparators: Game.UpgradesById[117],
        farFutureEnactment: Game.UpgradesById[199],

        sugarBosons: Game.UpgradesById[99],
        stringTheory: Game.UpgradesById[100],
        largeMacaronCollider: Game.UpgradesById[101],
        bigBangBake: Game.UpgradesById[102],
        reverseCyclotrons: Game.UpgradesById[118],
        nanocosmics: Game.UpgradesById[200],

        gemPolish: Game.UpgradesById[175],
        ninthColor: Game.UpgradesById[176],
        chocolateLight: Game.UpgradesById[177],
        grainbow: Game.UpgradesById[178],
        pureCosmicLight: Game.UpgradesById[179],
        glowInTheDark: Game.UpgradesById[201],

        // this makes santa level upgrades somewhat Game.Upgrade-like, for
        // consumption later down.
        santaLevel: {
            get: function () {
                "use strict";
                this.update();
                return this;
            },
            update: function () {
                "use strict";
                this.desc = (function () {
                    if (Game.santaLevel + 1 >= Game.santaLevels.length) {
                        return "";
                    }
                    return Game.santaLevels[Game.santaLevel + 1];
                }());
                this.baseDesc = this.desc;
                this.basePrice = this.getPrice();
                this.unlocked = (function () {
                    var self = Cheetah.constants.upgrades.santaLevel;
                    if (Game.santaLevel + 1 >= Game.santaLevels.length) {
                        return 0;
                    }
                    if (!Game.Upgrades["A festive hat"].bought) {
                        return 0;
                    }
                    if (self.basePrice > Game.cookies) {
                        return 0;
                    }
                    return 1;
                }());
            },
            id: Game.santaLevel,
            name: "Santa Level Up",
            desc: "",
            baseDesc: "",
            basePrice: 0,
            icon: null,
            buyFunction: null,
            unlocked: 0,
            bought: 0,
            hide: 0,
            order: Game.santaLevel,
            type: "",
            power: 0,
            vanilla: Game.vanilla,
            techUnlock: [],

            getPrice: function () {
                "use strict";
                return Math.pow(Game.santaLevel + 1, Game.santaLevel + 1);
            },

            buy: function () {
                "use strict";
                Game.mouseX = 48;
                Game.mouseY = Game.LeftBackground.canvas.height - 48 - 24;
                Game.Click = true;
            },
            earn: null,

            toggle: function () {
                "use strict";
                if (this.bought) {
                    Game.santaLevel -= 1;
                } else {
                    this.bought = 1;
                    Game.santaLevel += 1;
                }
            }
        }
    },

    version: "1.0465.1.0"
};

Cheetah.constants.upgrades.eggs.common = [
    Cheetah.constants.upgrades.eggs.chicken,
    Cheetah.constants.upgrades.eggs.duck,
    Cheetah.constants.upgrades.eggs.turkey,
    Cheetah.constants.upgrades.eggs.quail,
    Cheetah.constants.upgrades.eggs.robin,
    Cheetah.constants.upgrades.eggs.ostrich,
    Cheetah.constants.upgrades.eggs.cassowary,
    Cheetah.constants.upgrades.eggs.salmonRoe,
    Cheetah.constants.upgrades.eggs.frogspawn,
    Cheetah.constants.upgrades.eggs.shark,
    Cheetah.constants.upgrades.eggs.turtle,
    Cheetah.constants.upgrades.eggs.antLarva
];
Cheetah.constants.upgrades.eggs.rare = [
    Cheetah.constants.upgrades.eggs.goldenGoose,
    Cheetah.constants.upgrades.eggs.faberge,
    Cheetah.constants.upgrades.eggs.wrinklerspawn,
    Cheetah.constants.upgrades.eggs.cookie,
    Cheetah.constants.upgrades.eggs.omelette,
    Cheetah.constants.upgrades.eggs.chocolate,
    Cheetah.constants.upgrades.eggs.century,
    Cheetah.constants.upgrades.eggs.egg
];

Cheetah.constants.upgrades.eggs.nonCps = [
    Cheetah.constants.upgrades.eggs.chocolate,
    Cheetah.constants.upgrades.eggs.faberge,
    Cheetah.constants.upgrades.eggs.omelette,
    Cheetah.constants.upgrades.eggs.wrinklerspawn
];

Cheetah.constants.upgrades.elders = {
    cps: [
        Cheetah.constants.upgrades.oneMind,
        Cheetah.constants.upgrades.exoticNuts,
        Cheetah.constants.upgrades.communalBrainsweep,
        Cheetah.constants.upgrades.arcaneSugar,
        Cheetah.constants.upgrades.elderPact
    ],
    nonCps: [
        Cheetah.constants.upgrades.elderPledge,
        Cheetah.constants.upgrades.elderCovenant,
        Cheetah.constants.upgrades.revokeElderCovenant,
        Cheetah.constants.upgrades.sacrificialRollingPins
    ]
};

Cheetah.constants.upgrades.golden = [
    Cheetah.constants.upgrades.luckyDay,
    Cheetah.constants.upgrades.serendipity,
    Cheetah.constants.upgrades.getLucky,
    Cheetah.constants.upgrades.eggs.goldenGoose
];
Cheetah.constants.upgrades.research = [
    Cheetah.constants.upgrades.persistentMemory
];
Cheetah.constants.upgrades.santaDrops = {
    cps: [
        Cheetah.constants.upgrades.increasedMerriness,
        Cheetah.constants.upgrades.improvedJolliness,
        Cheetah.constants.upgrades.aLumpOfCoal,
        Cheetah.constants.upgrades.anItchySweater,
        Cheetah.constants.upgrades.reindeerBakingGrounds,
        Cheetah.constants.upgrades.weightedSleighs,
        Cheetah.constants.upgrades.hoHoHoFlavoredFrosting,
        Cheetah.constants.upgrades.seasonSavings,
        Cheetah.constants.upgrades.toyWorkshop,
        Cheetah.constants.upgrades.naughtyList,
        Cheetah.constants.upgrades.santasBottomlessBag,
        Cheetah.constants.upgrades.santasHelpers,
        Cheetah.constants.upgrades.santasLegacy,
        Cheetah.constants.upgrades.santasMilkAndCookies
    ],
    nonCps: [
        Cheetah.constants.upgrades.reindeerBakingGrounds,
        Cheetah.constants.upgrades.weightedSleighs,
        Cheetah.constants.upgrades.hoHoHoFlavoredFrosting,
        Cheetah.constants.upgrades.seasonSavings,
        Cheetah.constants.upgrades.toyWorkshop,
        Cheetah.constants.upgrades.santasBottomlessBag
    ]
};

Cheetah.constants.upgrades.seasonsByName = {
    christmas: Cheetah.constants.upgrades.festiveBiscuit,
    easter: Cheetah.constants.upgrades.bunnyBiscuit,
    halloween: Cheetah.constants.upgrades.ghostlyBiscuit,
    valentines: Cheetah.constants.upgrades.lovesickBiscuit,
    fools: Cheetah.constants.upgrades.foolsBiscuit
};
if (Game.version > Cheetah.constants.compatibleGameVersion) {
    var warning;
    warning = "WARNING: The game has been updated. ";
    warning += "Keep an eye out for broken automatics.";
    console.log(warning);
}

Cheetah.constants.upgrades.seasons = (function () {
    "use strict";
    var s, seasons;

    seasons = [];
    for (s in Cheetah.constants.upgrades.seasonsByName) {
        if (Cheetah.constants.upgrades.seasonsByName.hasOwnProperty(s)) {
            seasons.push(Cheetah.constants.upgrades.seasonsByName[s]);
        }
    }

    return seasons;
}());

Cheetah.constants.upgrades.bankShorting = (function () {
    "use strict";
    var s;
    s = Cheetah.constants.upgrades.elders.cps.slice();
    s = s.concat(Cheetah.constants.upgrades.elders.nonCps);
    s = s.concat(Cheetah.constants.upgrades.eggs.nonCps);
    return s.concat(Cheetah.constants.upgrades.seasons);
}());

Cheetah.constants.upgrades.nonCps = (function () {
    "use strict";
    var ups;
    ups = Cheetah.constants.upgrades.elders.nonCps.slice();
    ups = ups.concat(Cheetah.constants.upgrades.golden);
    ups = ups.concat(Cheetah.constants.upgrades.research);
    ups = ups.concat(Cheetah.constants.upgrades.seasons);
    ups = ups.concat(Cheetah.constants.upgrades.santaDrops.nonCps);
    ups = ups.concat(Cheetah.constants.upgrades.eggs.nonCps);

    return ups;
}());

/*
if (Game.version >= Cheetah.constants.compatibleGameVersion) {
}
*/

Cheetah.constants.upgrades.excludedFromCpsSelector = (function () {
    "use strict";
    var excludes, i;

    excludes = Cheetah.constants.upgrades.nonCps.slice();
    excludes = excludes.concat(Cheetah.constants.upgrades.elders.cps);

    for (i = 0; i < excludes.length; i += 1) {
        excludes[i] = excludes[i].id;
    }

    return excludes;
}());


// main.js:109 (Cheetah.constants.compatibleGameVersion)
Cheetah.beautify = {
    long: function (value, floats) {
        "use strict";
        return Cheetah.beautify.short(value, floats, true);
    },

    round: {
        long: function (value) {
            "use strict";
            var f = Cheetah.beautify.long;
            return Cheetah.beautify.round.rounded(value, f);
        },
        rounded: function (value, f) {
            "use strict";
            var number, space;

            value = f(value);
            space = value.indexOf(" ");
            if (space < 0) {
                return Math.round(value);
            }

            number = parseFloat(value.substring(0, space));
            if (isNaN(number)) {
                return value;
            }

            return Math.round(number) + value.substring(space);
        },
        short: function (value) {
            "use strict";
            var f = Cheetah.beautify.short;
            return Cheetah.beautify.round.rounded(value, f);
        }
    },

    floatsForSmall: function (value) {
        "use strict";
        var f;
        if (value === 0) {
            return 0;
        }
        value = Math.abs(value);
        if (value >= 1) {
            return 0;
        }
        f = 1;
        for (value = value * 10; value < 1; value *= 10) {
            f += 1;
        }
        return f;
    },
    short: function (value, floats, long) {
        "use strict";
        var decimal, formatter, negative, output;

        negative = (value < 0 ? "-" : "");
        decimal = "";
        if (value < 1000000) {
            if (!floats) {
                floats = Cheetah.beautify.floatsForSmall(value);
            }
            if (floats) {
                decimal = ".";
                decimal += (value.toFixed(floats).toString()).split(".")[1];
            }
        }
        value = Math.floor(Math.abs(value));
        if (long) {
            formatter = numberFormatters[Game.prefs.format ? 0 : 1];
        } else {
            formatter = numberFormatters[Game.prefs.format ? 0 : 2];
        }

        output = formatter(value).toString();

        return negative + output + decimal;
    }
};

Cheetah.BuildingBundle = function (i, n) {
    "use strict";
    if (n instanceof Array) {
        i = n[0];
        n = n[1];
    }
    return {
        object: Game.ObjectsById[i],
        amount: n - Game.ObjectsById[i].amount
    };
};



Cheetah.click = {
    all: function () {
        "use strict";

        if (Cheetah.state.resetting) {
            return;
        }

        Cheetah.click.popupCookie();
        Cheetah.click.reindeer();
        Cheetah.click.wrinklers();

        if (Cheetah.click.never()) {
            return;
        }

        Cheetah.click.bigCookie();
    },

    // update "going for Neverclick" state, return true if big cookie should not
    // be clicked after this
    never: function () {
        "use strict";

        if (Cheetah.state.neverclicked) {
            return false;
        }

        if (!Cheetah.state.goForNeverclick) {
            return false;
        }

        if (Game.Achievements.Neverclick.won) {
            Cheetah.state.goForNeverclick = false;
            Cheetah.state.neverclicked = true;
            return false;
        }

        return (Game.cookieClicks === 15);
    },

    bigCookie: function () {
        "use strict";
        var i, m, r, time, timeNow, times;

        timeNow = Date.now();

        time = timeNow - Cheetah.state.bigClick.time;

        if (Cheetah.state.speedyClick()) {
            m = Cheetah.config.intervals.bigClick.duringFrenzy;
        } else {
            m = Cheetah.config.intervals.bigClick.normal;
        }

        times = time / m;
        if (times <= 0) {
            return;
        }
        times = Math.floor(times);

        r = time % m;
        Cheetah.state.bigClick.remainder += r;
        if (Cheetah.state.bigClick.remainder / m >= 1) {
            times += Math.floor(Cheetah.state.bigClick.remainder / m);
            r = Cheetah.state.bigClick.remainder % m;
            Cheetah.state.bigClick.remainder = r;
        }

        Cheetah.state.bigClick.time = timeNow;
        for (i = 0; i < times; i += 1) {
            Game.ClickCookie();
        }
    },

    popupCookie: function () {
        "use strict";
        if (!Cheetah.state.click.popupCookie()) {
            return;
        }

        Game.goldenCookie.click();
    },

    reindeer: function () {
        "use strict";

        Cheetah.debug.seasonPopup.countSpawned();

        if (!Cheetah.state.click.reindeer()) {
            return;
        }

        Cheetah.debug.seasonPopup.countClicked();

        Game.seasonPopup.click();
    },

    wrinklers: function () {
        "use strict";
        var i;

        if (!Cheetah.state.click.wrinklers()) {
            return;
        }

        for (i = 0; i < Game.wrinklers.length; i += 1) {
            if (Game.wrinklers[i].sucked > 0) {
                Game.wrinklers[i].hp = 0;
            }
        }
    }
};



// compare two items, a cpc-wise better one and a worse one.
// return false if the worse one actually makes more sense to buy first.
Cheetah.compare = {
    items: function (better, worse) {
        "use strict";
        var cookiesInBank, cps, t;

        if (!better) {
            return false;
        }

        if (!worse) {
            return true;
        }

        cps = Cheetah.count.cps.total.current();

        if (cps === 0) {
            return worse.price > better.price;
        }

        cookiesInBank = Cheetah.count.cookies.inBank();

        t = {};
        t.better = (better.price - cookiesInBank) / cps;
        if (t.better <= 0) {
            return true;
        }
        t.worse = (worse.price - cookiesInBank) / cps;
        t.worseAfterBetter = worse.price / (cps + better.cps);
        t.betterAfterWorse = better.price / (cps + worse.cps);
        t.betterFirstThenWorse = t.better + t.worseAfterBetter;
        t.worseFirstThenBetter = t.worse + t.betterAfterWorse;

        return (t.worseFirstThenBetter > t.betterFirstThenWorse);
    },

    // compare given currently selected item to banking.
    // return true if banking capital is reached quicker by making the purchase
    // first.
    purchaseToBanking: function () {
        "use strict";
        var cps, purchase, netPrice, toBank, t;

        cps = Cheetah.count.cps.total.current();

        if (cps === 0) {
            return true;
        }

        purchase = Cheetah.state.selection.selectedItem;
        if (!purchase) {
            return false;
        }

        if (purchase.cps === 0) {
            return false;
        }

        t = {};

        t.banking = Cheetah.count.time.till.cookiesInBank();
        if (t.banking <= 0) {
            return false;
        }

        toBank = 12000 * Game.cookiesPs - Game.cookies;
        t.banking = toBank / cps;
        netPrice = purchase.price;
        t.purchaseAfterBanking = netPrice / cps;
        t.bankingFirstThenPurchase = t.banking + t.purchaseAfterBanking;

        toBank = 12000 * (Game.cookiesPs + purchase.cps * Game.frenzyPower);
        t.bankingAfterPurchase = toBank / (cps + purchase.cps);
        netPrice = purchase.price;
        t.purchase = netPrice / cps;
        t.purchaseFirstThenBanking = t.purchase + t.bankingAfterPurchase;

        return (t.purchaseFirstThenBanking < t.bankingFirstThenPurchase);
    }
};


Cheetah.count = {
    achievements: {
        haveObjects: {
            anyType: {
                gained: {
                    from: function (b) {
                        "use strict";
                        var as, ho, i, n;

                        ho = Cheetah.constants.achievements.haveObjects.anyType;
                        n = Cheetah.count.buildings() + b.object.amount;

                        as = 0;
                        for (i = ho.objectsNeeded.length; i >= 0; i -= 1) {
                            if (ho.objectsNeeded[i] <= n) {
                                if (!Game.Achievements[ho.list[i]].won) {
                                    as += 1;
                                }
                            }
                        }

                        return as;
                    }
                }
            },

            gained: {
                from: function (b) {
                    "use strict";
                    var a1, an, as, ho;

                    ho = Cheetah.count.achievements.haveObjects;

                    a1 = ho.oneType.gained.from(b);
                    an = ho.anyType.gained.from(b);
                    as = ho.special.gained.from(b);

                    return a1 + an + as;
                }
            },

            oneType: {
                gained: {
                    from: function (b) {
                        "use strict";
                        var as, ho, i, n;

                        ho = Cheetah.constants.achievements.haveObjects.oneType;
                        ho = ho[b.object.id];

                        n = b.object.amount + b.amount;

                        as = 0;
                        for (i = ho.objectsNeeded.length; i >= 0; i -= 1) {
                            if (ho.objectsNeeded[i] <= n) {
                                if (!Game.Achievements[ho.list[i]].won) {
                                    as += 1;
                                }
                            }
                        }

                        return as;
                    }
                }
            },
            special: {
                gained: {
                    from: function (b) {
                        "use strict";
                        var a, as, ho, s;

                        ho = Cheetah.constants.achievements.haveObjects.special;
                        s = Cheetah.count.achievements.haveObjects.special;

                        as = 0;
                        for (a in ho) {
                            if (ho.hasOwnProperty(a)) {
                                if (!Game.Achievements[a].won) {
                                    as += s.gained.with(b, ho[a]);
                                }
                            }
                        }

                        return as;
                    },
                    with: function (b, neededF) {
                        "use strict";
                        var a, i, n, needed;

                        a = 0;
                        for (i = 0; i < Game.ObjectsById.length; i += 1) {
                            n = Game.ObjectsById[i].amount;
                            if (i === b.object.id) {
                                n += b.amount;
                            }
                            needed = neededF(i);
                            if (needed <= n) {
                                a += 1;
                            }
                        }
                        return (a < Game.ObjectsById.length ? 0 : 1);
                    }
                }
            }
        },
        santa: {
            gainedFromLevelUp: function () {
                "use strict";
                var a, aLevel;

                aLevel = Cheetah.constants.achievements.santa;
                for (a in aLevel) {
                    if (aLevel.hasOwnProperty(a)) {
                        if (!Game.Achievements[a].won) {
                            if (Game.santaLevel + 1 >= aLevel[a]) {
                                return 1;
                            }
                        }
                    }
                }

                return 0;
            }
        }
    },

    buildings: function () {
        "use strict";
        var buildingsOwned, i;

        buildingsOwned = 0;
        for (i = 0; i < Game.ObjectsById.length; i += 1) {
            buildingsOwned += Game.ObjectsById[i].amount;
        }

        return buildingsOwned;
    },

    cookies: {

        inBank: function () {
            "use strict";
            var w;

            if (isNaN(Game.cookies)) {
                w = "WARNING: Game.cookies is NaN.";
                Cheetah.debug.log(w);
            }
            if (isNaN(Game.cookiesPs)) {
                w = "WARNING: Game.cookiesPs is NaN.";
                Cheetah.debug.log(w);
            }
            if (!Cheetah.state.bankingCookies()) {
                return Game.cookies;
            }

            return Game.cookies - Cheetah.count.luckyBank();
        },

        gained: {
            from: {
                chocolateEggAfterSellout: function () {
                    "use strict";
                    var selloutGain;
                    if (!Game.Upgrades["Chocolate egg"].unlocked) {
                        return 0;
                    }

                    if (Game.Upgrades["Chocolate egg"].bought) {
                        return 0;
                    }

                    selloutGain = Cheetah.count.cookies.gained.from.sellout();
                    return (Game.cookies + selloutGain) * 0.05;
                },
                poppingWrinklers: function () {
                    "use strict";
                    var i, barf;

                    barf = 0;
                    for (i = 0; i < Game.wrinklers.length; i += 1) {
                        if (Game.wrinklers[i].sucked > 0) {
                            barf += 1.1 * Game.wrinklers[i].sucked;
                        }
                    }

                    return barf;
                },
                sellingNth: function (n, i) {
                    "use strict";
                    var amount, price;
                    amount = Game.ObjectsById[i].amount - (n - 1);
                    price = Game.ObjectsById[i].basePrice;
                    price *= 0.5 * Math.pow(Game.priceIncrease, amount);
                    return Math.floor(price);
                },
                selling: function (i) {
                    "use strict";
                    var amount, gained, n, price;

                    amount = Game.ObjectsById[i].amount;
                    gained = 0;
                    for (n = 1; n <= amount; n += 1) {
                        price = Game.ObjectsById[i].getPrice();
                        gained += Math.floor(0.5 * price);
                        Game.ObjectsById[i].amount -= 1;
                    }
                    Game.ObjectsById[i].amount = amount;

                    return gained;
                },
                sellout: function () {
                    "use strict";
                    var gained, i, obs, sold;

                    sold = [];
                    obs = Game.ObjectsById;
                    for (i = obs.length - 1; i >= 0; i -= 1) {
                        sold.push(0);
                    }

                    gained = 0;
                    for (i = obs.length - 1; i >= 0; i -= 1) {
                        gained += Cheetah.count.cookies.gained.from.selling(i);
                    }

                    return gained;
                }
            }
        },

        remainingToGainFor: {
            achievements: {
                all: function () {
                    "use strict";
                    var a, ac, c;

                    a = Cheetah.count.cookies.remainingToGainFor.achievements;

                    c = 0;

                    ac = a.bake();
                    c = Math.max(c, ac);

                    ac = a.click();
                    c = Math.max(c, ac);

                    ac = a.elder();
                    c = Math.max(c, ac);

                    ac = a.cps();
                    c = Math.max(c, ac);

                    ac = a.haveObjects();
                    c = Math.max(c, ac);

                    ac = a.objectMade();
                    c = Math.max(c, ac);

                    ac = a.resetWith();
                    c = Math.max(c, ac);

                    return c;
                },

                elder: function () {
                    "use strict";
                    var a, i, c, n;

                    if (!Cheetah.state.enterGrandmapocalypse()) {
                        return 0;
                    }

                    a = Cheetah.constants.achievements.elder;
                    c = 0;
                    for (i in a) {
                        if (a.hasOwnProperty(i)) {
                            if (!Game.Achievements[i].won) {
                                n = a[i]();
                                c = Math.max(c, n);
                            }
                        }
                    }

                    return c;
                },

                bake: function () {
                    "use strict";
                    var a, b, i, c, n;

                    a = Game.moneyAchievs;
                    b = Cheetah.state.achievements.attainable.bake;
                    c = 0;
                    for (i = 0; i < a.length / 2; i += 1) {
                        if (b.one(i)) {
                            n = a[i * 2 + 1] - Game.cookiesEarned;
                            c = Math.max(c, n);
                        }
                    }

                    return c;
                },

                click: function (i) {
                    "use strict";
                    var a, b, c, n;

                    a = Cheetah.constants.achievements.click;
                    b = Cheetah.state.achievements.attainable.click;
                    c = 0;
                    for (i = 0; i < a.length; i += 1) {
                        if (b.one(i)) {
                            n = 1000 * Math.pow(100, i);
                            n -= Game.handmadeCookies;
                            c = Math.max(c, n);
                        }
                    }

                    return c;
                },

                cps: function () {
                    "use strict";
                    var a, b, i, c, n;

                    a = Game.cpsAchievs;
                    b = Cheetah.state.achievements.attainable.cps;
                    c = 0;
                    for (i = 0; i < a.length / 2; i += 1) {
                        if (b.one(i)) {
                            n = Cheetah.state.selection.selectedItem.price;
                            n -= Cheetah.count.cookies.inBank();
                            c = Math.max(c, n);
                        }
                    }

                    return c;
                },

                haveObjects: function () {
                    "use strict";
                    var anyType, oneType, r;

                    r = Cheetah.count.cookies.remainingToGainFor.achievements;
                    oneType = r.haveOneTypeObjects();

                    // this is not quite so simple. I should have a "bundle of
                    // N cheapest buildings" option to purchase to make it work,
                    // or even better, a "bundle of N next optimal buildings".
                    // both are so much work for so little to gain that I
                    // probably will not bother, as the current maximum
                    // (mentioned below) is easily reached beside other goals
                    // anyway.
                    // main.js:5075 (Cheetah.constants.compatibleGameVersion)
                    // "Lord of Constructs", 1500 buildings
                    anyType = 0;

                    return Math.max(anyType, oneType);
                },

                haveOneTypeObjects: function () {
                    "use strict";
                    var a, c, getPrice, ho, i, j, name, n, p;

                    a = Cheetah.constants.achievements.haveObjects.oneType;
                    ho = Cheetah.state.achievements.attainable.haveObjects;
                    ho = ho.oneType;
                    getPrice = Cheetah.count.price.for.object.bundle;

                    c = 0;
                    for (i = 0; i < a.length; i += 1) {
                        for (j = 0; j < a[i].list.length; j += 1) {
                            name = a[i].list[j];
                            n = a[i].objectsNeeded[j];
                            if (ho.onePerObject(i, name, n)) {
                                p = getPrice(i, n);
                                c = Math.max(c, p);
                            }
                        }
                    }

                    return c;
                },

                objectMade: function () {
                    "use strict";
                    var a, i, j, c, n;

                    a = Cheetah.constants.achievements.objectMade.cookiesNeeded;
                    j = Cheetah.state.achievements.attainable.objectMade;
                    c = 0;
                    for (i = 0; i < Game.ObjectsById.length; i += 1) {
                        if (j.one(i)) {
                            n = a[i] - Game.ObjectsById[i].totalCookies;
                            c = Math.max(c, n);
                        }
                    }

                    return c;
                },
                resetWith: function () {
                    "use strict";
                    var a, i, c, n, r;

                    a = Cheetah.constants.achievements.resetWith;
                    r = Cheetah.state.achievements.attainable.resetWith;
                    c = 0;
                    for (i = 0; i < a.length; i += 1) {
                        if (r.one(i)) {
                            n = 1000000 * Math.pow(1000, i);
                            n -= Game.cookiesEarned;
                            c = Math.max(c, n);
                        }
                    }

                    return c;
                }
            },

            hcGain: function (hc) {
                "use strict";
                var needed;

                hc += Game.prestige["Heavenly chips"];
                needed = (hc * (hc + 1)) / 2 * 1e+12;

                return needed - Game.cookiesReset;
            },

            reset: function () {
                "use strict";
                var a, hc, rc;

                if (Cheetah.state.goForNeverclick) {
                    rc = 1000000 - Game.cookiesEarned;
                    rc = Math.max(0, rc);
                    return rc;
                }

                rc = 0;

                hc = Cheetah.count.cookies.remainingToGainFor.resetHc();
                rc = Math.max(rc, hc);

                a = Cheetah.count.cookies.remainingToGainFor.achievements.all();
                rc = Math.max(rc, a);

                return rc;
            },

            resetHc: function () {
                "use strict";
                var c, hc, price;

                hc = Cheetah.count.heavenlyChips.toGainToReset();
                price = Cheetah.count.cookies.remainingToGainFor.hcGain(hc);
                c = Cheetah.count.cookies;
                c = c.gained.from.chocolateEggAfterSellout();

                return price - Game.cookiesEarned - c;
            }
        }
    },

    cps: {
        autoclick: function () {
            "use strict";
            var mouseMultiplier;

            if (Cheetah.state.goForNeverclick) {
                return 0;
            }

            if (Cheetah.state.speedyClick()) {
                mouseMultiplier = Cheetah.config.clicksPerSecond.duringFrenzy;
            } else {
                mouseMultiplier = Cheetah.config.clicksPerSecond.normal;
            }

            return Game.mouseCps() * mouseMultiplier;
        },

        // current "raw" mouse cps, i.e. with any possible frenzy effects
        // subtracted and not counting the autoclicker.
        // main.js:1475 (Cheetah.constants.compatibleGameVersion)
        frenzylessMouse: function () {
            "use strict";
            var add, ambidextrous, base, bonus, carpalTunnelPrevention, cps, i,
                mult, num, overallMultiplier, reinforcedIndexFinger;

            reinforcedIndexFinger = Game.Has("Reinforced index finger");
            carpalTunnelPrevention = Game.Has("Carpal tunnel prevention cream");
            ambidextrous = Game.Has("Ambidextrous");

            base = 1;
            add = reinforcedIndexFinger;
            mult = carpalTunnelPrevention + ambidextrous;

            bonus = 0;
            if (Game.Has("Thousand fingers")) { bonus += 0.1; }
            if (Game.Has("Million fingers")) { bonus += 0.5; }
            if (Game.Has("Billion fingers")) { bonus += 2; }
            if (Game.Has("Trillion fingers")) { bonus += 10; }
            if (Game.Has("Quadrillion fingers")) { bonus += 20; }
            if (Game.Has("Quintillion fingers")) { bonus += 100; }
            if (Game.Has("Sextillion fingers")) { bonus += 200; }
            if (Game.Has("Septillion fingers")) { bonus += 400; }
            if (Game.Has("Octillion fingers")) { bonus += 800; }

            num = 0;
            for (i in Game.Objects) {
                if (Game.Objects.hasOwnProperty(i)) {
                    num += Game.Objects[i].amount;
                }
            }
            num -= Game.Objects.Cursor.amount;
            bonus *= num;

            cps = Game.cookiesPs;
            if (Game.frenzy) {
                cps /= Game.frenzyPower;
            }

            if (Game.Has("Plastic mouse")) { bonus += cps * 0.01; }
            if (Game.Has("Iron mouse")) { bonus += cps * 0.01; }
            if (Game.Has("Titanium mouse")) { bonus += cps * 0.01; }
            if (Game.Has("Adamantium mouse")) { bonus += cps * 0.01; }
            if (Game.Has("Unobtainium mouse")) { bonus += cps * 0.01; }
            if (Game.Has("Eludium mouse")) { bonus += cps * 0.01; }
            if (Game.Has("Wishalloy mouse")) { bonus += cps * 0.01; }

            overallMultiplier = 1;
            for (i = 0; i < Game.customMouseCps.length; i += 1) {
                overallMultiplier += Game.customMouseCps[i]();
            }

            if (Game.Has("Santa's helpers")) { overallMultiplier *= 1.1; }
            if (Game.Has("Cookie egg")) { overallMultiplier *= 1.1; }

            return overallMultiplier * Game.ComputeCps(base, add, mult, bonus);
        },


        gain: {
            from: {
                achievements: function (n) {
                    "use strict";
                    var milk, mult, oldMult;

                    if (!Game.Has("Kitten helpers")) {
                        return 0;
                    }

                    milk = Math.pow(1.04, n) * Game.milkProgress;
                    mult = Cheetah.count.cps.multiplier.total(milk);
                    oldMult = Cheetah.count.cps.multiplier.total();

                    return Game.cookiesPs * mult / oldMult - Game.cookiesPs;
                },

                building: function (candidate) {
                    "use strict";
                    var b, countCps, cps1, cps2, n;

                    countCps = Cheetah.count.cps;

                    n = candidate.amount + 1;
                    b = new Cheetah.BuildingBundle(candidate.id, n);
                    cps2 = countCps.gain.from.buildingAchievement(b);

                    candidate.amount += 1;
                    Game.CalculateGains();
                    cps2 += Cheetah.count.cps.total.current();

                    candidate.amount -= 1;
                    Game.CalculateGains();
                    cps1 = Cheetah.count.cps.total.current();

                    return cps2 - cps1;
                },

                buildingAchievement: function (b) {
                    "use strict";
                    var a, ho;

                    ho = Cheetah.count.achievements.haveObjects;
                    a = ho.gained.from(b);

                    return Cheetah.count.cps.gain.from.achievements(a);
                },

                buildingBundle: function (b) {
                    "use strict";
                    var countCps, cps1, cps2;

                    countCps = Cheetah.count.cps;

                    b.object.amount += b.amount;
                    Game.CalculateGains();
                    cps2 = countCps.total.current();

                    b.object.amount -= b.amount;
                    Game.CalculateGains();
                    cps1 = Cheetah.count.cps.total.current();

                    return cps2 - cps1;
                },

                buildingsAndUpgrade: function (b, up) {
                    "use strict";
                    var countCps, cps1, cps2, hijackedBuy;

                    countCps = Cheetah.count.cps;

                    cps2 = countCps.gain.from.buildingAchievement(b);

                    b.object.amount += b.amount;
                    if (up.buyFunction) {
                        Cheetah.state.hijackedFunctions = true;
                        hijackedBuy = up.buyFunction;
                        up.buyFunction = null;
                    }
                    up.toggle();
                    Game.CalculateGains();
                    cps2 += countCps.total.current();

                    up.toggle();
                    b.object.amount -= b.amount;
                    Game.CalculateGains();
                    cps1 = Cheetah.count.cps.total.current();

                    if (Cheetah.state.hijackedFunctions) {
                        up.buyFunction = hijackedBuy;
                        Cheetah.state.hijackedFunctions = false;
                    }

                    return cps2 - cps1;
                },

                upgrade: function (candidate) {
                    "use strict";
                    var cps1, cps2, hijackedBuy;

                    if (candidate.buyFunction) {
                        Cheetah.state.hijackedFunctions = true;
                        hijackedBuy = candidate.buyFunction;
                        candidate.buyFunction = null;
                    }

                    Game.UpgradesById[candidate.id].toggle();
                    Game.CalculateGains();
                    cps2 = Cheetah.count.cps.total.current();

                    Game.UpgradesById[candidate.id].toggle();
                    Game.CalculateGains();
                    cps1 = Cheetah.count.cps.total.current();

                    if (Cheetah.state.hijackedFunctions) {
                        candidate.buyFunction = hijackedBuy;
                        Cheetah.state.hijackedFunctions = false;
                    }

                    return cps2 - cps1;
                },

                santaLevelUp: function () {
                    "use strict";
                    var a, cps1, cps2;

                    if (!Game.Upgrades["Santa's legacy"].bought) {
                        return 0;
                    }

                    if (Game.santaLevel >= Game.santaLevels.length - 1) {
                        return 0;
                    }

                    Game.santaLevel += 1;
                    Game.CalculateGains();
                    cps2 = Cheetah.count.cps.total.current();

                    Game.santaLevel -= 1;
                    Game.CalculateGains();
                    cps1 = Cheetah.count.cps.total.current();

                    a = Cheetah.count.achievements.santa.gainedFromLevelUp();
                    a = Cheetah.count.cps.gain.from.achievements(a);

                    return cps2 - cps1 + a;
                }
            }
        },

        multiplier: {
            // main.js:1686 (Cheetah.constants.compatibleGameVersion)
            egg: function () {
                "use strict";
                var day, eggMult;

                eggMult = 0;
                if (Game.Has("Chicken egg")) { eggMult += 1; }
                if (Game.Has("Duck egg")) { eggMult += 1; }
                if (Game.Has("Turkey egg")) { eggMult += 1; }
                if (Game.Has("Quail egg")) { eggMult += 1; }
                if (Game.Has("Robin egg")) { eggMult += 1; }
                if (Game.Has("Ostrich egg")) { eggMult += 1; }
                if (Game.Has("Cassowary egg")) { eggMult += 1; }
                if (Game.Has("Salmon roe")) { eggMult += 1; }
                if (Game.Has("Frogspawn")) { eggMult += 1; }
                if (Game.Has("Shark egg")) { eggMult += 1; }
                if (Game.Has("Turtle egg")) { eggMult += 1; }
                if (Game.Has("Ant larva")) { eggMult += 1; }
                if (Game.Has("Century egg")) {
                    day = new Date().getTime() - Game.startDate;
                    day = Math.floor(day / 1000 / 10) * 10 / 60 / 60 / 24;
                    day = Math.min(day, 100);
                    eggMult += (1 - Math.pow(1 - day / 100, 3)) * 10;
                }

                return 1 + 0.01 * eggMult;
            },

            // main.js:1679 (Cheetah.constants.compatibleGameVersion)
            milk: function (milk) {
                "use strict";
                var base, milkMult;

                milkMult = 1;
                milk = milk || Game.milkProgress;
                if (Game.Has("Santa's milk and cookies")) {
                    base = 1.05;
                } else {
                    base = 1;
                }

                if (Game.Has("Kitten helpers")) {
                    milkMult *= 1 + milk * 0.05 * base;
                }
                if (Game.Has("Kitten workers")) {
                    milkMult *= 1 + milk * 0.1 * base;
                }
                if (Game.Has("Kitten engineers")) {
                    milkMult *= 1 + milk * 0.2 * base;
                }
                if (Game.Has("Kitten overseers")) {
                    milkMult *= 1 + milk * 0.2 * base;
                }
                if (Game.Has("Kitten managers")) {
                    milkMult *= 1 + milk * 0.2 * base;
                }

                return milkMult;
            },

            bonus: {
                christmas: function () {
                    "use strict";
                    var mult;

                    mult = 0;

                    if (Game.Has("Increased merriness")) { mult += 0.15; }
                    if (Game.Has("Improved jolliness")) { mult += 0.15; }
                    if (Game.Has("A lump of coal")) { mult += 0.01; }
                    if (Game.Has("An itchy sweater")) { mult += 0.01; }
                    if (Game.Has("Santa's dominion")) { mult += 0.5; }

                    if (Game.Has("Santa's legacy")) {
                        mult += (Game.santaLevel + 1) * 0.1;
                    }

                    return mult;
                },
                cookies: function () {
                    "use strict";
                    var i, mult, u;

                    mult = 0;
                    for (i = 0; i < Game.UpgradesById.length; i  +=  1) {
                        u = Game.UpgradesById[i];
                        if (Game.Has(u.name) && u.type === "cookie") {
                            mult += u.power * 0.01;
                        }
                    }

                    return mult;
                },
                custom: function () {
                    "use strict";
                    var i, mult;

                    mult = 0;
                    for (i = 0; i < Game.customCps.length; i += 1) {
                        mult += Game.customCps[i]();
                    }

                    return mult;
                },
                elders: function () {
                    "use strict";
                    var mult;

                    mult = 0;

                    mult += Game.Has("Specialized chocolate chips") * 0.01;
                    mult += Game.Has("Designer cocoa beans") * 0.02;
                    mult += Game.Has("Underworld ovens") * 0.03;
                    mult += Game.Has("Exotic nuts") * 0.04;
                    mult += Game.Has("Arcane sugar") * 0.05;

                    return mult;
                },
                heavenly: function () {
                    "use strict";
                    var mult;

                    if (!Game.prestige.ready) { Game.CalculatePrestige(); }

                    mult = 0;

                    if (Game.Has("Heavenly chip secret")) { mult += 0.05; }
                    if (Game.Has("Heavenly cookie stand")) { mult += 0.20; }
                    if (Game.Has("Heavenly bakery")) { mult += 0.25; }
                    if (Game.Has("Heavenly confectionery")) { mult += 0.25; }
                    if (Game.Has("Heavenly key")) { mult += 0.25; }

                    mult *= 0.02;

                    return parseFloat(Game.prestige["Heavenly chips"]) * mult;
                },
                total: function () {
                    "use strict";
                    var mult;

                    mult = 0;
                    mult += Cheetah.count.cps.multiplier.bonus.cookies();
                    mult += Cheetah.count.cps.multiplier.bonus.elders();
                    mult += Cheetah.count.cps.multiplier.bonus.christmas();
                    mult += Cheetah.count.cps.multiplier.bonus.heavenly();
                    mult += Cheetah.count.cps.multiplier.bonus.custom();

                    return mult;
                }
            },
            custom: function () {
                "use strict";
                var i, mult;

                mult = 1;
                for (i = 0; i < Game.customCpsMult.length; i += 1) {
                    mult *= Game.customCpsMult[i]();
                }

                return mult;
            },

            // main.js:1632 (Cheetah.constants.compatibleGameVersion)
            total: function (milk) {
                "use strict";
                var mult;

                mult = 1;
                mult += Cheetah.count.cps.multiplier.bonus.total();

                milk = milk || Game.milkProgress;
                mult *= Cheetah.count.cps.multiplier.milk(milk);

                mult *= Cheetah.count.cps.multiplier.egg();

                if (Game.frenzy > 0) { mult *= Game.frenzyPower; }
                if (Game.Has("Elder Covenant")) { mult *= 0.95; }
                if (Game.Has("Golden switch")) { mult *= 1.25; }

                mult *= Cheetah.count.cps.multiplier.custom();

                return mult;
            }
        },

        production: function () {
            "use strict";

            return Game.cookiesPs * (1 - Game.cpsSucked);
        },

        // main.js:1715-1737 (Cheetah.constants.compatibleGameVersion)
        raw: function () {
            "use strict";
            var i, mult;

            mult = 1;
            if (Game.frenzy > 0) { mult *= Game.frenzyPower; }
            if (Game.Has("Elder Covenant")) { mult *= 0.95; }
            if (Game.Has("Golden switch")) { mult *= 1.25; }
            for (i = 0; i < Game.customCpsMult.length; i += 1) {
                mult *= Game.customCpsMult[i]();
            }

            return Game.cookiesPs / mult;
        },

        total: {
            current: function () {
                "use strict";
                var a, p;

                p = Cheetah.count.cps.production();
                a = Cheetah.count.cps.autoclick();

                return p + a;
            },

            during: {

                // effective cps when measured during a combo
                comboFrenzy: function () {
                    "use strict";
                    return Cheetah.count.cps.total.current();
                },

                // effective production-only frenzy cps, when measured during
                // one, or combo
                productionFrenzy: function () {
                    "use strict";
                    var a, multiplier, p;

                    p = Cheetah.count.cps.production();

                    if (Cheetah.state.goForNeverclick) {
                        a = 0;
                    } else {
                        a = Game.mouseCps();
                        if (Game.clickFrenzy > 0) {
                            a /= 777;
                        }

                        multiplier = Cheetah.config.clicksPerSecond;
                        if (Cheetah.state.underSpeedyClickLimit()) {
                            multiplier = multiplier.duringFrenzy;
                        } else {
                            multiplier = multiplier.normal;
                        }
                        a *= multiplier;
                    }

                    return p + a;
                },

                // effective click-only frenzy cps, when measured during one,
                // or combo
                clickFrenzy: function () {
                    "use strict";
                    var a, p;

                    p = Game.cookiesPs;
                    if (Game.frenzy) {
                        a = Cheetah.count.cps.frenzylessMouse() * 777;
                        p /= Game.frenzyPower;
                    } else {
                        a = Cheetah.count.cps.autoclick();
                    }
                    a *= Cheetah.config.clicksPerSecond.duringFrenzy;
                    if (Cheetah.state.goForNeverclick) {
                        a = 0;
                    }

                    // Game.MouseCps() also uses Game.cookiesPs, so for
                    // measuring during a combo it needs to be replaced by one
                    // that subtracts the frenzy effect (because we want a
                    // click-only frenzy cps).

                    return p + a;
                },

                // get the effective no-frenzy cps, during any frenzy (even
                // combo)
                noFrenzy: function () {
                    "use strict";
                    var a, m, p;

                    p = Cheetah.count.cps.production();
                    if (Game.frenzy) {
                        p /= Game.frenzyPower;
                    }

                    if (Cheetah.state.goForNeverclick) {
                        a = 0;
                    } else {
                        a = Cheetah.count.cps.frenzylessMouse();
                        m = Cheetah.config.clicksPerSecond;
                        if (Cheetah.state.underSpeedyClickLimit()) {
                            a *= m.duringFrenzy;
                        } else {
                            a *= m.normal;
                        }
                    }

                    return p + a;
                }
            }
        }
    },

    heavenlyChips: {
        import: function (data) {
            "use strict";
            var p = new Cheetah.Importer(
                ["per"],
                "heavenlyChips",
                Cheetah.count.heavenlyChips
            );
            return p.import(data);
        },

        initialize: function () {
            "use strict";
            Cheetah.count.heavenlyChips.per.initialize();
        },

        per: {
            hour: {
                hcGained: function (hcNow) {
                    "use strict";
                    var p, hcLast;

                    p = Cheetah.count.heavenlyChips.per.hour;
                    if (p.data.buffer.hc.last < 0) {
                        hcLast = p.data.initial.hc;
                    } else {
                        hcLast = p.data.buffer.hc.last;
                    }
                    return hcNow - hcLast;
                },
                import: function (data) {
                    "use strict";
                    var p = new Cheetah.Importer(
                        ["data"],
                        "hour",
                        Cheetah.count.heavenlyChips.per.hour
                    );
                    return p.import(data);
                },
                initialize: function (time, hc) {
                    "use strict";
                    var p;
                    p = Cheetah.count.heavenlyChips.per.hour;
                    p.data.initialize(time, hc);
                },
                data: {
                    buffer: {
                        hc: {
                            gained: null,
                            import: function (data) {
                                "use strict";
                                var d, p;
                                d = Cheetah.count.heavenlyChips.per.hour.data;
                                p = new Cheetah.Importer(
                                    ["last", "gained"],
                                    "hc",
                                    d.buffer.hc
                                );
                                return p.import(data);
                            },
                            initialize: function (size) {
                                "use strict";
                                var b;
                                b = Cheetah.count.heavenlyChips.per.hour.data;
                                b = b.buffer.hc;
                                b.last = -1;
                                b.gained = new Cheetah.Ringbuffer(size);
                            },
                            last: -1
                        },
                        import: function (data) {
                            "use strict";
                            var p = new Cheetah.Importer(
                                ["hc", "time"],
                                "buffer",
                                Cheetah.count.heavenlyChips.per.hour.data.buffer
                            );
                            return p.import(data);
                        },
                        initialize: function () {
                            "use strict";
                            var d, size;

                            d = Cheetah.count.heavenlyChips.per.hour.data;
                            size = 60;
                            d.buffer.hc.initialize(size);
                            d.buffer.time.initialize(size);
                        },
                        time: {
                            import: function (data) {
                                "use strict";
                                var d, p;
                                d = Cheetah.count.heavenlyChips.per.hour.data;
                                p = new Cheetah.Importer(
                                    ["last", "passed"],
                                    "time",
                                    d.buffer.time
                                );
                                return p.import(data);
                            },
                            initialize: function (size) {
                                "use strict";
                                var b;
                                b = Cheetah.count.heavenlyChips.per.hour.data;
                                b = b.buffer.time;
                                b.last = -1;
                                b.passed = new Cheetah.Ringbuffer(size);
                            },
                            last: -1,
                            passed: null
                        }
                    },
                    import: function (data) {
                        "use strict";
                        var p = new Cheetah.Importer(
                            ["buffer", "initial", "hcph"],
                            "data",
                            Cheetah.count.heavenlyChips.per.hour.data
                        );
                        return p.import(data);
                    },
                    initial: {
                        hc: 0,
                        import: function (data) {
                            "use strict";
                            var d, p;
                            d = Cheetah.count.heavenlyChips.per.hour.data;
                            p = new Cheetah.Importer(
                                ["hc", "time"],
                                "initial",
                                d.initial
                            );
                            return p.import(data);
                        },
                        initialize: function (time, hc) {
                            "use strict";
                            var d;
                            d = Cheetah.count.heavenlyChips.per.hour.data;
                            d = d.initial;
                            d.hc = hc;
                            d.time = time;
                        },
                        time: 0
                    },
                    initialize: function (time, hc) {
                        "use strict";
                        var buffer, p;
                        p = Cheetah.count.heavenlyChips.per.hour;
                        buffer = p.data.buffer;
                        buffer.initialize();
                        p.data.initial.initialize(time, hc);
                        p.data.hcph = 0;
                    },
                    hcph: 0
                },
                timePassed: function (timeNow) {
                    "use strict";
                    var p, timeLast;

                    p = Cheetah.count.heavenlyChips.per.hour;
                    if (p.data.buffer.time.last < 0) {
                        timeLast = p.data.initial.time;
                    } else {
                        timeLast = p.data.buffer.time.last;
                    }

                    return timeNow - timeLast;
                },
                update: function (timeNow, hcNow) {
                    "use strict";
                    var b, combined, hcGained, hcph, hour, minute, p,
                        timePassed;

                    hour = 60 * 60 * 1000; // ms
                    minute = 60 * 1000;

                    combined = {};
                    p = Cheetah.count.heavenlyChips.per.hour;

                    timePassed = p.timePassed(timeNow);
                    if (timePassed < minute) {
                        return;
                    }
                    b = p.data.buffer.time;
                    b.passed.push(timePassed);
                    b.last = timeNow;
                    combined.time = b.passed.sum();

                    hcGained = p.hcGained(hcNow);
                    b = p.data.buffer.hc;
                    b.gained.push(hcGained);
                    b.last = hcNow;
                    combined.hc = b.gained.sum();

                    hcph = (hour * combined.hc / combined.time);
                    p.data.hcph = hcph;
                }
            },

            import: function (data) {
                "use strict";
                var p = new Cheetah.Importer(
                    ["hour", "minute"],
                    "per",
                    Cheetah.count.heavenlyChips.per
                );
                return p.import(data);
            },

            initialize: function () {
                "use strict";
                var hc, p, time;

                time = Date.now();
                if (Cheetah.state.resetting && !Cheetah.state.importing) {
                    hc = 0;
                } else {
                    hc = Cheetah.count.heavenlyChips.gained();
                }

                p = Cheetah.count.heavenlyChips.per;
                p.hour.initialize(time, hc);
                p.minute.initialize(time, hc);
            },
            minute: {
                hcGained: function (hcNow) {
                    "use strict";
                    var p, hcLast;

                    p = Cheetah.count.heavenlyChips.per.minute;
                    if (p.data.buffer.hc.last < 0) {
                        hcLast = p.data.initial.hc;
                    } else {
                        hcLast = p.data.buffer.hc.last;
                    }
                    return hcNow - hcLast;
                },
                import: function (data) {
                    "use strict";
                    var p = new Cheetah.Importer(
                        ["data"],
                        "hour",
                        Cheetah.count.heavenlyChips.per.minute
                    );
                    return p.import(data);
                },
                initialize: function (time, hc) {
                    "use strict";
                    var p;
                    p = Cheetah.count.heavenlyChips.per.minute;
                    p.data.initialize(time, hc);
                },
                data: {
                    buffer: {
                        hc: {
                            gained: null,
                            import: function (data) {
                                "use strict";
                                var d, p;
                                d = Cheetah.count.heavenlyChips.per.minute.data;
                                p = new Cheetah.Importer(
                                    ["last", "gained"],
                                    "hc",
                                    d.buffer.hc
                                );
                                return p.import(data);
                            },
                            initialize: function (size) {
                                "use strict";
                                var b;
                                b = Cheetah.count.heavenlyChips.per.minute.data;
                                b = b.buffer.hc;
                                b.last = -1;
                                b.gained = new Cheetah.Ringbuffer(size);
                            },
                            last: -1
                        },
                        import: function (data) {
                            "use strict";
                            var d, p;
                            d = Cheetah.count.heavenlyChips.per.minute.data;
                            p = new Cheetah.Importer(
                                ["hc", "time"],
                                "buffer",
                                d.buffer
                            );
                            return p.import(data);
                        },
                        initialize: function () {
                            "use strict";
                            var d, size;

                            d = Cheetah.count.heavenlyChips.per.minute.data;
                            size = 60;
                            d.buffer.hc.initialize(size);
                            d.buffer.time.initialize(size);
                        },
                        time: {
                            import: function (data) {
                                "use strict";
                                var d, p;
                                d = Cheetah.count.heavenlyChips.per.minute.data;
                                p = new Cheetah.Importer(
                                    ["last", "passed"],
                                    "time",
                                    d.buffer.time
                                );
                                return p.import(data);
                            },
                            initialize: function (size) {
                                "use strict";
                                var b;
                                b = Cheetah.count.heavenlyChips.per.minute.data;
                                b = b.buffer.time;
                                b.last = -1;
                                b.passed = new Cheetah.Ringbuffer(size);
                            },
                            last: -1,
                            passed: null
                        }
                    },
                    import: function (data) {
                        "use strict";
                        var p = new Cheetah.Importer(
                            ["buffer", "initial", "hcpm"],
                            "data",
                            Cheetah.count.heavenlyChips.per.minute.data
                        );
                        return p.import(data);
                    },
                    initial: {
                        hc: 0,
                        import: function (data) {
                            "use strict";
                            var d, p;
                            d = Cheetah.count.heavenlyChips.per.minute.data;
                            p = new Cheetah.Importer(
                                ["hc", "time"],
                                "initial",
                                d.initial
                            );
                            return p.import(data);
                        },
                        initialize: function (time, hc) {
                            "use strict";
                            var d;
                            d = Cheetah.count.heavenlyChips.per.minute.data;
                            d = d.initial;
                            d.hc = hc;
                            d.time = time;
                        },
                        time: Date.now()
                    },
                    initialize: function (time, hc) {
                        "use strict";
                        var buffer, p;
                        p = Cheetah.count.heavenlyChips.per.minute;
                        buffer = p.data.buffer;
                        buffer.initialize();
                        p.data.initial.initialize(time, hc);
                        p.data.hcpm = 0;
                    },
                    hcpm: 0
                },
                timePassed: function (timeNow) {
                    "use strict";
                    var p, timeLast;

                    p = Cheetah.count.heavenlyChips.per.minute;
                    if (p.data.buffer.time.last < 0) {
                        timeLast = p.data.initial.time;
                    } else {
                        timeLast = p.data.buffer.time.last;
                    }

                    return timeNow - timeLast;
                },
                update: function (timeNow, hcNow) {
                    "use strict";
                    var b, combined, hcGained, hcpm, minute, p, second,
                        timePassed;

                    minute = 60 * 1000; // ms
                    second = 1000;

                    combined = {};
                    p = Cheetah.count.heavenlyChips.per.minute;

                    timePassed = p.timePassed(timeNow);
                    if (timePassed < second) {
                        return;
                    }
                    b = p.data.buffer.time;
                    b.passed.push(timePassed);
                    b.last = timeNow;
                    combined.time = b.passed.sum();

                    hcGained = p.hcGained(hcNow);
                    b = p.data.buffer.hc;
                    b.gained.push(hcGained);
                    b.last = hcNow;
                    combined.hc = b.gained.sum();

                    hcpm = (minute * combined.hc / combined.time);
                    p.data.hcpm = hcpm;
                }
            },
            update: function (time, hc) {
                "use strict";
                var h, m, p;

                p = Cheetah.count.heavenlyChips.per;

                h = p.hour;
                h.update(time, hc);

                m = p.minute;
                m.update(time, hc);
            }
        },

        gained: function () {
            "use strict";
            var allTimeCookies, allTimeHc, currentHc, warning;

            allTimeCookies = Game.cookiesReset + Game.cookiesEarned;
            if (isNaN(allTimeCookies)) {
                warning = "WARNING: allTimeCookies is NaN.";
                Cheetah.debug.log(warning);
            }
            allTimeHc = Game.HowMuchPrestige(allTimeCookies);
            if (isNaN(allTimeHc)) {
                warning = "WARNING: allTimeHc is NaN.";
                Cheetah.debug.log(warning);
            }
            if (!Game.prestige.ready) { Game.CalculatePrestige(); }
            currentHc = Game.prestige["Heavenly chips"];
            if (isNaN(currentHc)) {
                warning = "WARNING: currentHc is NaN.";
                Cheetah.debug.log(warning);
            }

            return allTimeHc - currentHc;
        },

        toGainToReset: function () {
            "use strict";
            var hc, minimum, percent, percentage;

            minimum = Cheetah.config.autoResetHcGainLimit.minimum;
            percent = Cheetah.config.autoResetHcGainLimit.percent() / 100;
            hc = Game.prestige["Heavenly chips"];
            percentage = Math.round(hc * percent);

            return Math.max(percentage, minimum);
        },

        update: function () {
            "use strict";
            var hc, time;

            time = Date.now();
            hc = Cheetah.count.heavenlyChips.gained();

            Cheetah.count.heavenlyChips.per.update(time, hc);
        }
    },

    import: function (data) {
        "use strict";
        var p = new Cheetah.Importer(
            ["heavenlyChips"],
            "count",
            Cheetah.count
        );
        return p.import(data);
    },

    initialize: function () {
        "use strict";
        Cheetah.count.heavenlyChips.initialize();
        Cheetah.count.initialized = true;
    },
    initialized: false,

    lockedUpgrades: {
        between: function (lower, upper) {
            "use strict";
            var i, nLeft;

            nLeft = 1;

            nLeft += upper - lower;
            for (i = lower; i < upper; i += 1) {
                if (Game.UpgradesById[i].unlocked) {
                    nLeft -= 1;
                }
            }

            return nLeft;
        },

        christmas: function () {
            "use strict";
            var lower, nLeft, upper;

            nLeft = 0;
            lower = 143;
            upper = 149;
            nLeft += Cheetah.count.lockedUpgrades.between(lower, upper);

            lower = 152;
            upper = 166;
            nLeft += Cheetah.count.lockedUpgrades.between(lower, upper);

            lower = 168;
            upper = 168;
            nLeft += Cheetah.count.lockedUpgrades.between(lower, upper);

            return nLeft;
        },

        easter: function () {
            "use strict";
            var lower, nLeft, upper;

            nLeft = 0;
            lower = 210;
            upper = 229;
            nLeft += Cheetah.count.lockedUpgrades.between(lower, upper);

            return nLeft;
        },

        eggs: {
            common: function () {
                "use strict";
                var e, eggs, n;

                eggs = Cheetah.constants.upgrades.eggs.common;
                n = 0;
                for (e = 0; e < eggs.length; e += 1) {
                    if (!eggs[e].unlocked) {
                        n += 1;
                    }
                }

                return n;
            },
            good: function () {
                "use strict";
                var e, eggs, good, useless;

                useless = [
                    "Omelette",
                    "Wrinklerspawn",
                    "\"egg\""
                ];
                if (Game.prestige["Heavenly chips"] < 10000) {
                    useless.push("Chocolate egg");
                }
                eggs = Cheetah.constants.upgrades.eggs.rare;
                good = 0;
                for (e = 0; e < eggs.length; e += 1) {
                    if (!eggs[e].unlocked) {
                        if (useless.indexOf(eggs[e].name) < 0) {
                            good += 1;
                        }
                    }
                }

                return good;
            },
            rare: function () {
                "use strict";
                var e, eggs, n;

                eggs = Cheetah.constants.upgrades.eggs.rare;
                n = 0;
                for (e = 0; e < eggs.length; e += 1) {
                    if (!eggs[e].unlocked) {
                        n += 1;
                    }
                }

                return n;
            }
        },

        fools: function () {
            "use strict";
            return 0;
        },

        halloween: function () {
            "use strict";
            var lower, upper;

            lower = 134;
            upper = 140;

            return Cheetah.count.lockedUpgrades.between(lower, upper);
        },

        valentines: function () {
            "use strict";
            var lower, upper;

            lower = 169;
            upper = 174;

            return Cheetah.count.lockedUpgrades.between(lower, upper);
        },

        currentSeason: function () {
            "use strict";
            switch (Game.season) {
            case "christmas":
                return Cheetah.count.lockedUpgrades.christmas();
            case "easter":
                return Cheetah.count.lockedUpgrades.easter();
            case "fools":
                return Cheetah.count.lockedUpgrades.fools();
            case "halloween":
                return Cheetah.count.lockedUpgrades.halloween();
            case "valentines":
                return Cheetah.count.lockedUpgrades.valentines();
            case "":
                return false;
            default:
                return true;
            }
        }
    },

    // "for maximum gain from lucky cookies you need to have 12,000 times your
    //  CpS". unaffected by wrinklers (cpsSucked). http://ur1.ca/guumf
    luckyBank: function () {
        "use strict";
        return Cheetah.constants.luckyBankMultiplier * Game.cookiesPs;
    },

    price: {
        for: {
            object: {
                bundle: function (id, n) {
                    "use strict";
                    var currentAmount, i, o, p, w;

                    if (n < 1) {
                        w = "WARNING: supposedly locked objectUpgrade ";
                        w += id + " ";
                        w += "is reachable without building purchases ";
                        w += "(n = 0).";
                        Cheetah.debug.log(w);
                        return 0;
                    }

                    o = Game.ObjectsById[id];
                    currentAmount = o.amount;

                    p = o.getPrice();
                    for (i = 1; i < n; i += 1) {
                        o.amount += 1;
                        p += o.getPrice();
                    }

                    o.amount = currentAmount;

                    return p;
                },

                number: function (b, n) {
                    "use strict";
                    return b.basePrice * Math.pow(Game.priceIncrease, n);
                }
            }
        }
    },

    time: {
        till: {
            gain: {
                in: {
                    clickFrenzy: function (gt) {
                        "use strict";
                        var countGainTime, cps, frenzyTime, timeBetween;

                        cps = Cheetah.count.cps.total.during.clickFrenzy();

                        timeBetween = Cheetah.count.time.between.frenzies;
                        frenzyTime = timeBetween.comboAndClickEnd();

                        countGainTime = Cheetah.count.time.till.gain.in.frenzy;
                        countGainTime(frenzyTime, cps, gt);

                        return gt;
                    },
                    comboFrenzy: function (gt) {
                        "use strict";
                        var countGainTime, frenzyCps, frenzyTime;

                        countGainTime = Cheetah.count.time.till.gain.in.frenzy;
                        frenzyCps = Cheetah.count.cps.total.during.comboFrenzy();
                        frenzyTime = Cheetah.count.time.till.comboFrenzyOver();

                        countGainTime(frenzyTime, frenzyCps, gt);

                        return gt;
                    },
                    frenzy: function (frenzyTime, frenzyCps, gt) {
                        "use strict";
                        var frenzyGainTime;

                        if (!frenzyTime) {
                            return gt;
                        }

                        frenzyGainTime = gt.cookiesToGain / frenzyCps;
                        if (frenzyGainTime <= frenzyTime) {
                            gt.time += frenzyGainTime;
                            gt.cookiesToGain = 0;
                        } else {
                            gt.time += frenzyTime;
                            gt.cookiesToGain -= frenzyCps * frenzyTime;
                        }

                        return gt;
                    },
                    noFrenzy: function (gt) {
                        "use strict";
                        var cps;

                        cps = Cheetah.count.cps.total.during.noFrenzy();
                        gt.time += gt.cookiesToGain / cps;
                        gt.cookiesToGain = 0;

                        return gt;
                    },
                    productionFrenzy: function (gt) {
                        "use strict";
                        var countGainTime, frenzyCps, frenzyTime, timeBetween;

                        countGainTime = Cheetah.count.time.till.gain.in.frenzy;
                        timeBetween = Cheetah.count.time.between.frenzies;
                        frenzyCps = Cheetah.count.cps.total.during.productionFrenzy();
                        frenzyTime = timeBetween.comboAndProductionEnd();

                        countGainTime(frenzyTime, frenzyCps, gt);

                        return gt;
                    }
                }
            },

            allFrenziesOver: function () {
                "use strict";
                if (Game.frenzy > Game.clickFrenzy) {
                    return Game.frenzy / Game.fps;
                }

                return Game.clickFrenzy / Game.fps;
            },
            comboFrenzyOver: function () {
                "use strict";
                if (Game.frenzy > Game.clickFrenzy) {
                    return Game.clickFrenzy / Game.fps;
                }

                return Game.frenzy / Game.fps;
            },

            priceReached: function (price) {
                "use strict";
                var gainTime;

                if (Math.round(price) <= 0) {
                    return 0;
                }

                gainTime = {
                    time: 0,
                    cookiesToGain: price
                };

                Cheetah.count.time.till.gain.in.comboFrenzy(gainTime);
                if (gainTime.cookiesToGain === 0) {
                    return gainTime.time;
                }

                Cheetah.count.time.till.gain.in.productionFrenzy(gainTime);
                if (gainTime.cookiesToGain === 0) {
                    return gainTime.time;
                }

                Cheetah.count.time.till.gain.in.clickFrenzy(gainTime);
                if (gainTime.cookiesToGain === 0) {
                    return gainTime.time;
                }

                Cheetah.count.time.till.gain.in.noFrenzy(gainTime);

                return gainTime.time;
            },
            cookiesInBank: function () {
                "use strict";
                var netPrice, price;

                // unaffected by wrinklers (cpsSucked)
                price = Cheetah.count.luckyBank();
                netPrice = price - Game.cookies;

                return Cheetah.count.time.till.priceReached(netPrice);
            },

            purchase: function (price) {
                "use strict";
                var netPrice;

                price = price || Cheetah.state.selection.selectedItem.price;
                netPrice = price - Cheetah.count.cookies.inBank();

                return Cheetah.count.time.till.priceReached(netPrice);
            },

            purchaseOfBuildingBundle: function (b) {
                "use strict";
                var cib, cps, getPrice, i, needed, price, t;

                getPrice = Cheetah.count.price.for.object.number;
                cib = Cheetah.count.cookies.inBank();
                cps = Cheetah.count.cps.total.current();
                t = 0;
                for (i = 0; i < b.amount; i += 1) {
                    price = getPrice(b.object, b.object.amount + i);
                    if (price > cib) {
                        needed = price - cib;
                        cib = 0;
                    } else {
                        needed = 0;
                        cib -= price;
                    }
                    t += needed / cps;
                    cps += b.object.cps();
                }

                return t;
            }
        },

        between: {
            cibAndPurchase: function () {
                "use strict";
                var difference, sCib, sPurchase;

                sCib = Cheetah.count.time.till.cookiesInBank();
                sPurchase = Cheetah.count.time.till.purchase();
                difference = sCib - sPurchase;
                difference = Math.max(difference, 0);

                return difference;
            },
            frenzies: {
                comboAndProductionEnd: function () {
                    "use strict";
                    var combo, frenzy;

                    frenzy = Game.frenzy / Game.fps;

                    combo = Cheetah.count.time.till.comboFrenzyOver();
                    if (!combo) {
                        return frenzy;
                    }

                    return Math.max(frenzy - combo, 0);
                },
                comboAndClickEnd: function () {
                    "use strict";
                    var combo, frenzy;

                    frenzy = Game.clickFrenzy / Game.fps;

                    combo = Cheetah.count.time.till.comboFrenzyOver();
                    if (!combo) {
                        return frenzy;
                    }

                    return Math.max(frenzy - combo, 0);
                }
            }
        }
    },

    update: function () {
        "use strict";

        if (!Cheetah.count.initialized) { return; }

        if (Cheetah.state.resetting) { return; }

        Cheetah.count.heavenlyChips.update();
    }
};

Cheetah.debug = {
    autoInstantBuy: function () {
        "use strict";
        var tr;

        if (Cheetah.debug.autoInstantBuyLimit < 1) {
            return false;
        }

        tr = Cheetah.count.time.till.purchase();
        return (tr > Cheetah.debug.autoInstantBuyLimit);
    },
    autoInstantBuyLimit: 0, // seconds, < 1 to disable

    finishResearch: function () {
        "use strict";
        var t;
        t = Game.researchT / Game.fps;
        t = Cheetah.prettyText.time.fromSeconds(t);
        Cheetah.debug.log("Cheated " + t + " in research.");
        Game.researchT = 0;
    },

    forcedSelection: false,

    gainCookies: function (c, earn) {
        "use strict";
        Game.cookies += c;
        if (earn) {
            Game.cookiesEarned += c;
        } else {
            Game.cookiesEarned += (function () {
                var p;
                p = Game.ObjectsById[Game.ObjectsById.length - 1].getPrice();

                return Math.max(p - Game.cookiesEarned, 0);
            }());
        }
    },

    gainCookiesForInstantBuy: function (earn) {
        "use strict";
        var cookies, gain, price, w;

        if (!Cheetah.state.selection.done) {
            Cheetah.debug.log("Instant buy: selection not complete yet.");
            return;
        }

        cookies = Cheetah.count.cookies.inBank();
        if (cookies < 0) {
            Cheetah.debug.gainCookies(Math.abs(cookies));
            cookies = Cheetah.count.cookies.inBank();
        } else {
            cookies = 0;
        }

        price = Cheetah.state.selection.selectedItem.price;
        if (cookies < price) {
            gain = price - cookies;
            Cheetah.debug.gainCookies(gain, earn);
        } else {
            Cheetah.debug.log("Instant buy: price already reached.");
            return;
        }

        if (earn) {
            w = "Cheated " + Math.round(gain) + " earned cookies.";
        } else {
            w = "Cheated " + Math.round(gain) + " cookies.";
        }
        Cheetah.debug.log(w);
    },

    initialize: function () {
        "use strict";
        return;
    },

    // enable/disable cheating with keypress
    keys: {
        instantBuy: true,
        instantResearch: true
    },
    log: function (text) {
        "use strict";
        var date, l, reps;

        if (!Cheetah.debug.logging.on) {
            return;
        }

        if (text === Cheetah.debug.logging.previousEntry.text) {
            Cheetah.debug.logging.previousEntry.repeated += 1;
            return;
        }

        l = Cheetah.constants.locale.date;
        date = new Date().toLocaleDateString("fi", l);

        reps = Cheetah.debug.logging.previousEntry.repeated;
        if (reps > 0) {
            if (reps > 1) {
                reps = date + ": (Previous entry repeated ";
                reps += Cheetah.debug.logging.previousEntry.repeated + " ";
                reps += "times.)";
            } else {
                reps = date + ": (Previous entry repeated once.)";
            }
            console.log(reps);
        }
        Cheetah.debug.logging.previousEntry.repeated = 0;

        if (Cheetah.debug.logging.cheatedCookies.log(text, date)) {
            return;
        }

        console.log(date + ": " + text);

        Cheetah.debug.logging.previousEntry.text = text;
    },
    logging: {
        cheatedCookies: {
            dump: function (date) {
                "use strict";
                var cookies, previous, text;

                previous = Cheetah.debug.logging.previousEntry;

                text = "Cheated ";
                if (previous.cheatedCookies < 0) {
                    previous.cheatedCookies = Math.abs(previous.cheatedCookies);
                    cookies = Cheetah.beautify.long(previous.cheatedCookies);
                    text += cookies + " cookies.";
                } else {
                    cookies = Cheetah.beautify.long(previous.cheatedCookies);
                    text += cookies + " earned cookies.";
                }
                date = previous.date;
                console.log(date + ": " + text);
                previous.cheatedCookies = 0;
                previous.date = date;
                previous.repeated = 0;
                previous.text = text;
            },
            log: function (text, date) {
                "use strict";
                var cheated, dump, earn, matches, previous, re;

                previous = Cheetah.debug.logging.previousEntry;
                re = /^Cheated (\d+) (earned )?cookies\./g;
                matches = re.exec(text);
                if (matches === null) {
                    if (previous.text === "/CHEATED COOKIES/") {
                        Cheetah.debug.logging.cheatedCookies.dump(date);
                    }
                    return false;
                }

                cheated = parseFloat(matches[1]);
                if (previous.text !== "/CHEATED COOKIES/") {
                    previous.cheatedCookies = cheated;
                    if (matches[2] === "earned ") {
                        previous.cheatedCookies *= -1;
                    }
                } else {
                    earn = matches[2];
                    dump = (earn && previous.cheatedCookies < 0);
                    dump = dump || (!earn && previous.cheatedCookies > 0);
                    if (dump) {
                        Cheetah.debug.logging.cheatedCookies.dump(date);
                        previous.cheatedCookies = 0;
                    }
                    if (earn) {
                        previous.cheatedCookies += cheated;
                    } else {
                        previous.cheatedCookies -= cheated;
                    }
                }

                previous.date = date;
                previous.text = "/CHEATED COOKIES/";
                previous.repeated = 0;
                return true;
            }
        },
        on: true,
        previousEntry: {
            cheatedCookies: 0,
            date: "",
            text: "",
            repeated: 0
        }
    },
    newSeason: false,
    newSeasonStopper: function () {
        "use strict";
        var warning;

        if (Cheetah.debug.newSeason) {
            return true;
        }

        if (Cheetah.constants.seasons.indexOf(Game.baseSeason) < 0) {
            if (Game.baseSeason !== "") {
                warning = "WARNING: ";
                warning += "new season detected, ";
                warning += "automatic season changes disabled.";
                Cheetah.debug.log(warning);
                Cheetah.debug.newSeason = true;
                return true;
            }
        }

        return false;
    },
    seasonPopup: {
        active: true,
        clicked: 0,
        countClicked: function () {
            "use strict";
            Cheetah.debug.seasonPopup.clicked += 1;
        },
        countSpawned: function () {
            "use strict";
            var s = Game.seasonPopup;
            if (s.life === Math.ceil(Game.fps * s.dur) - 1) {
                Cheetah.debug.seasonPopup.spawned += 1;
            }
        },
        dump: function () {
            "use strict";
            var s = Cheetah.debug.seasonPopup;
            Cheetah.debug.log("Spawned: " + s.spawned);
            Cheetah.debug.log("Clicked: " + s.clicked);
            if (s.spawned !== s.clicked) {
                Cheetah.debug.log("Spawned and clicked amounts do not match!");
            }
        },
        spawned: 0
    }
};



Cheetah.import = function (data) {
    "use strict";
    var p = new Cheetah.Importer(
        ["version", "count", "ui"],
        "Cheetah",
        Cheetah
    );
    return p.import(data);
};
Cheetah.Importer = function (expected, name, o) {
    "use strict";
    this.expected = expected;
    this.name = name;
    this.o = o;
};
Cheetah.Importer.prototype.import = function (data) {
    "use strict";
    var e, i, n, o, w;

    e = this.expected;
    n = this.name;
    o = this.o;

    try {
        for (i = 0; i < e.length; i += 1) {
            if (data[e[i]] === undefined) {
                throw e[i] + " is not in loaded data " + data + ".";
            }
        }
        for (i = 0; i < e.length; i += 1) {
            if (o[e[i]] === undefined) {
                throw n + " has no " + e[i] + ".";
            }
        }
        for (i = 0; i < e.length; i += 1) {
            if (typeof o[e[i]] === "number") {
                if (typeof data[e[i]] !== "number") {
                    w = "mismatching type for " + e[i] + ": ";
                    w += "got " + typeof data[e[i]] + ", ";
                    w += "expected " + typeof o[e[i]] + ".";
                    throw w;
                }
                o[e[i]] = data[e[i]];
            } else if (typeof o[e[i]] === "string") {
                if (typeof data[e[i]] !== "string") {
                    w = "mismatching type for " + e[i] + ": ";
                    w += "got " + typeof data[e[i]] + ", ";
                    w += "expected " + typeof o[e[i]] + ".";
                    throw w;
                }
                o[e[i]] = data[e[i]];
            } else if (typeof o[e[i]] === "object") {
                if (typeof data[e[i]] !== "object") {
                    w = "mismatching type for " + e[i] + ": ";
                    w += "got " + typeof data[e[i]] + ", ";
                    w += "expected " + typeof o[e[i]] + ".";
                    throw w;
                }
                if (o[e[i]] === null) {
                    o[e[i]] = data[e[i]];
                } else {
                    if (!o[e[i]].import) {
                        throw n + "." + e[i] + " has no import().";
                    }
                    if (typeof o[e[i]].import !== "function") {
                        w = n + "." + e[i] + ".import is not a function ";
                        throw w + "but a " + typeof o[e[i]].import + ".";
                    }
                    if (!o[e[i]].import(data[e[i]])) {
                        throw "parsing " + e[i] + " failed.";
                    }
                }
            }
        }

        return true;
    } catch (err) {
        w = "ERROR: failed to import " + n + ": " + err;
        Cheetah.debug.log(w);
        return false;
    }
};

Cheetah.load = function () {
    "use strict";
    var str, save, w;

    save = Cheetah.constants.saveName;
    str = window.localStorage.getItem(save);

    if (!str) {
        w = "No previously saved Cheetah data found.";
        Cheetah.debug.log(w);
        return;
    }

    Cheetah.debug.log("Loaded previously saved Cheetah data.");
    // Cheetah.debug.log(str);

    Cheetah.import(JSON.parse(str));
};

Cheetah.loadSave = function (data) {
    "use strict";

    Cheetah.state.resetting = true;
    Cheetah.state.importing = true;

    if (Cheetah.state.hijackedFunctions) {
        setTimeout(function () {
            Cheetah.loadSave(data);
        }, 100);
        return;
    }

    Cheetah.constants.functions.game.loadSave(data);
    Cheetah.debug.log("Scratch all that, a new game imported.");
    Cheetah.initialize();
    setTimeout(function () {
        Cheetah.ui.announce.aim();
        Cheetah.state.importing = false;
        Cheetah.state.resetting = false;
    }, 5000); // hold off automatics to give Game time to finish
};

// main worker function, start untangling here
Cheetah.logic = function () {
    "use strict";

    Cheetah.click.all();

    Cheetah.update();

    // fuck off, notes
    Game.NotesLogic();

    Cheetah.constants.functions.game.logic();
};

Cheetah.prettyText = {
    fixed: {
        hc: function (value) {
            "use strict";
            if (value < 10) {
                return value.toFixed(1);
            }
            return value.toFixed(0);
        },

        // http://stackoverflow.com/a/1685917/717501
        big: function (x) {
            "use strict";
            var e;

            x = Math.round(x);
            if (Math.abs(x) < 1.0) {
                e = parseInt(x.toString().split("e-")[1], 10);
                if (e) {
                    x *= Math.pow(10, e - 1);
                    x = x.toString().substring(2);
                    x = "0." + new Array(e).join("0") + x;
                }
            } else {
                e = parseInt(x.toString().split("+")[1], 10);
                if (e > 20) {
                    e -= 20;
                    x /= Math.pow(10, e);
                    x += new Array(e + 1).join("0");
                }
            }
            return x;
        }
    },

    cookies: {
        till: {
            autoReset: function () {
                "use strict";
                var c, closeRed, openRed, redLimit, text;

                openRed = Cheetah.constants.tags.span.openRed;
                closeRed = Cheetah.constants.tags.span.closeRed;

                c = Cheetah.count.cookies.remainingToGainFor.reset();
                Cheetah.ui.ping.forReset(c);

                if (c === 0) {
                    return "";
                }

                text = "Cookies to earn till reset: ";
                if (Cheetah.state.goForNeverclick) {
                    text = "Cookies to neverclick till reset: ";
                }

                text += Cheetah.beautify.round.long(c);
                redLimit = Game.cookiesPs * 60 * 5;
                if (c < redLimit) {
                    text = openRed + text + closeRed;
                }

                return text;
            }
        }
    },

    purchase: function () {
        "use strict";
        var cpc, price;

        price = Cheetah.state.selection.selectedItem.price;
        price = Cheetah.beautify.long(price);

        if (Cheetah.state.selection.selectedItem.cps === 0) {
            return "priceless at " + price;
        }

        cpc = Cheetah.state.selection.selectedItem.cpc;
        cpc = Cheetah.beautify.short(cpc) + " c/cps";
        return "costing " + cpc + " at " + price;
    },

    time: {
        fromSeconds: function (seconds) {
            "use strict";
            var d, h, m, M, s, timeText, y, w;

            timeText = "";
            y = Math.floor(seconds / 3600 / 24 / 365.242199);
            seconds -= y * 365 * 24 * 3600;
            M = Math.floor(seconds / 3600 / 24 / 30.4368499);
            seconds -= M * 30 * 24 * 3600;
            w = Math.floor(seconds / 3600 / 24 / 7);
            seconds -= w * 7 * 24 * 3600;
            d = Math.floor(seconds / 3600 / 24);
            seconds -= d * 24 * 3600;
            h = Math.floor(seconds / 3600);
            seconds -= h * 3600;
            m = Math.floor(seconds / 60);
            seconds -= m * 60;
            s = Math.floor(seconds);

            if (y > 10000000) {
                y /= 10000000;
                y = Math.round(y);
                if (y === 1) {
                    timeText += "1 epoch";
                } else {
                    timeText += y + " epochs";
                }
            } else if (y >= 1000000) {
                y /= 1000000;
                y = Math.round(y);
                if (y === 1) {
                    timeText += "1 mega-annum";
                } else {
                    timeText += y + " mega-annums";
                }
            } else if (y >= 1000) {
                y /= 1000;
                y = Math.round(y);
                if (y === 1) {
                    timeText += "1 millennium";
                } else {
                    timeText += y + " millennia";
                }
            } else if (y >= 100) {
                y /= 100;
                y = Math.round(y);
                if (y === 1) {
                    timeText += "1 century";
                } else {
                    timeText += y + " centuries";
                }
            } else if (y >= 10) {
                y /= 10;
                y = Math.round(y);
                if (y === 1) {
                    timeText += "1 decade";
                } else {
                    timeText += y + " decades";
                }
            } else if (y) {
                timeText += y + "a";
                if (M) {
                    timeText += ", " + M + "m";
                }
            } else if (M) {
                timeText += M + "m";
                if (w) {
                    timeText += ", " + w + "w";
                }
            } else if (w) {
                timeText += w + "w";
                if (d) {
                    timeText += ", " + d + "d";
                }
            } else if (d) {
                timeText += d + "d";
                if (h) {
                    timeText += ", " + h + "h";
                }
            } else if (h) {
                timeText += h + ":";
                timeText += ("0" + m).slice(-2) + ":";
                timeText += ("0" + s).slice(-2);
            } else if (m) {
                timeText += m + ":";
                timeText += ("0" + s).slice(-2);
            } else {
                timeText += s;
            }

            return timeText;
        },

        between: {
            cibAndPurchase: function () {
                "use strict";
                var cibToPurchaseTime;
                cibToPurchaseTime = Cheetah.count.time.between.cibAndPurchase();
                return Cheetah.prettyText.time.fromSeconds(cibToPurchaseTime);
            }
        },

        till: {
            purchase: function () {
                "use strict";
                var eta, price, s, t, w;
                t = Cheetah.count.time.till.purchase();
                if (t < 1) {
                    return "";
                }
                eta = "ETR " + Cheetah.prettyText.time.fromSeconds(t);
                s = Cheetah.state.selection.selectedItem;
                if (s.amount > 1) {
                    if (!(s.gameObject instanceof Game.Object)) {
                        w = "WARNING: Selected item is not a Game.Object, ";
                        w += "but amount is " + s.amount + ".";
                        Cheetah.debug.log(w);
                        return eta;
                    }
                    price = s.gameObject.getPrice();
                    t = Cheetah.count.time.till.purchase(price);
                    t = Cheetah.prettyText.time.fromSeconds(t);
                    eta += " (" + t + " till next)";
                }
                return eta;
            },

            cookiesInBankText: function () {
                "use strict";
                var cookiesInBank = Cheetah.count.time.till.cookiesInBank();
                return Cheetah.prettyText.time.fromSeconds(cookiesInBank);
            }
        }
    },

    frenzy: function () {
        "use strict";
        var clickFrenzy, clickFrenzySeconds, clickFrenzyText, closeRed, frenzy,
            frenzyPrettyTime, frenzySeconds, frenzyText, openRed,
            textFromSeconds;

        frenzy = Game.frenzy;
        clickFrenzy = Game.clickFrenzy;
        if (frenzy === 0 && clickFrenzy === 0) {
            return "";
        }
        frenzySeconds = Math.round(frenzy / Game.fps);
        clickFrenzySeconds = Math.round(clickFrenzy / Game.fps);
        if (!frenzySeconds && !clickFrenzySeconds) {
            return "";
        }

        textFromSeconds = Cheetah.prettyText.time.fromSeconds;

        if (frenzySeconds) {
            frenzyPrettyTime = textFromSeconds(frenzySeconds);
            if (Game.frenzyPower < 1) {
                frenzyText = "Clot remaining: " + frenzyPrettyTime;
            } else {
                frenzyText = "Frenzy remaining: " + frenzyPrettyTime;
            }
        } else {
            frenzyText = "";
        }
        if (clickFrenzySeconds) {
            clickFrenzyText = textFromSeconds(clickFrenzySeconds);
            if (!frenzySeconds || Game.frenzyPower < 1) {
                frenzyText = "Click frenzy remaining: " + clickFrenzyText;
            } else {
                if (frenzy > clickFrenzy) {
                    frenzyText =  "Combo frenzy remaining: " + clickFrenzyText;
                } else {
                    frenzyText = "Combo frenzy remaining: " + frenzyPrettyTime;
                }

                openRed = Cheetah.constants.tags.span.openRed;
                closeRed = Cheetah.constants.tags.span.closeRed;
                frenzyText =  openRed + frenzyText + closeRed;
            }
        }

        return frenzyText;
    }
};



// http://stackoverflow.com/a/4774081/717501
Cheetah.Ringbuffer = function (length) {
    "use strict";
    this.buffer = [];
    this.length = length;
    this.pointer = 0;
};
Cheetah.Ringbuffer.prototype.get = function (key) {
    "use strict";
    return this.buffer[key];
};
Cheetah.Ringbuffer.prototype.getLast = function () {
    "use strict";
    return this.buffer[(this.pointer > 0 ? this.pointer : this.length) - 1];
};
Cheetah.Ringbuffer.prototype.max = function () {
    "use strict";
    return Math.max.apply(Math, this.buffer);
};
Cheetah.Ringbuffer.prototype.min = function () {
    "use strict";
    return Math.min.apply(Math, this.buffer);
};
Cheetah.Ringbuffer.prototype.import = function (data) {
    "use strict";
    var w;

    try {
        if (data.length === undefined) {
            w = "ERROR: Ringbuffer length is not in data.";
            Cheetah.debug.log(w);
            return false;
        }
        if (isNaN(data.length)) {
            w = "ERROR: Ringbuffer length (" + data.length + ") ";
            w += "is not a number.";
            Cheetah.debug.log(w);
            return false;
        }
        if (data.length < 0) {
            w = "ERROR: Ringbuffer length (" + data.length + ") is negative.";
            Cheetah.debug.log(w);
            return false;
        }

        this.length = data.length;

        if (data.pointer === undefined) {
            w = "ERROR: Ringbuffer pointer is not in data.";
            Cheetah.debug.log(w);
            return false;
        }
        if (isNaN(data.pointer)) {
            w = "ERROR: Ringbuffer pointer (" + data.pointer + ") ";
            w += "is not a number.";
            Cheetah.debug.log(w);
            return false;
        }
        if (data.pointer < 0) {
            w = "ERROR: Ringbuffer pointer (" + data.pointer + ") is negative.";
            Cheetah.debug.log(w);
            return false;
        }

        this.pointer = data.pointer;

        if (data.buffer === undefined) {
            w = "ERROR: Ringbuffer buffer is not in data.";
            Cheetah.debug.log(w);
            return false;
        }

        if (!Array.isArray(data.buffer)) {
            w = "ERROR: Ringbuffer buffer (" + data.buffer + ") ";
            w += "is not an array but a " + typeof data.buffer + ".";
            Cheetah.debug.log(w);
            return false;
        }

        this.buffer = data.buffer;

        return true;
    } catch (e) {
        w = "ERROR: failed to import Ringbuffer. ";
        w += "The error message was: " + e;
        Cheetah.debug.log(w);
        return false;
    }
};

Cheetah.Ringbuffer.prototype.push = function (item) {
    "use strict";
    this.buffer[this.pointer] = item;
    this.pointer = (this.length + this.pointer + 1) % this.length;
};
Cheetah.Ringbuffer.prototype.sum = function () {
    "use strict";
    return this.buffer.reduce(function (a, b) {
        return a + b;
    }, 0);
};



Cheetah.Selectable = function (gameObject, cpc, cps, price, amount, upgrade) {
    "use strict";
    this.amount = amount || 1;
    this.cpc = cpc || 0;
    this.cps = cps || 0;
    this.gameObject = gameObject;
    this.name = gameObject.name;
    if (Game.season === "fools" && gameObject.displayName) {
        Cheetah.state.selection.selectedItem.name = Game.foolNames[this.name];
    }
    this.price = price || gameObject.getPrice();
    this.upgrade = upgrade || null;
};


Cheetah.Selectable.prototype.buy = function () {
    "use strict";
    this.gameObject.buy();
};

Cheetah.select = {
    // select A festive hat when available
    aFestiveHat: function () {
        "use strict";
        var aFestiveHat, reachable, unbought, unlocked;

        if (Game.season !== "christmas") {
            return false;
        }

        aFestiveHat = Game.Upgrades["A festive hat"];
        reachable = Cheetah.state.reachable(aFestiveHat.getPrice());
        unbought = !aFestiveHat.bought;
        unlocked = aFestiveHat.unlocked;

        if (unbought && unlocked && reachable) {
            Cheetah.select.item(aFestiveHat);
            return true;
        }

        return false;
    },

    // select most cps-wise valuable building available if better than current
    // selection
    building: function () {
        "use strict";
        var i;

        for (i = Game.ObjectsById.length - 1; i >= 0; i -= 1) {
            Cheetah.select.object.number(i);
        }

        Cheetah.select.unwise();
    },

    comparativelyBetter: function (candidate) {
        "use strict";
        var better, currentSmallestCpc, worse;

        if (!Cheetah.state.selection.done) {
            return Cheetah.select.wiseOrUnwise(candidate);
        }

        if (candidate.cps <= 0) {
            return false;
        }

        if (Cheetah.state.selection.selectedItem.cps <= 0) {
            return Cheetah.select.wiseOrUnwise(candidate);
        }

        if (Cheetah.state.selection.selectedItem.cpc <= 0) {
            return Cheetah.select.wiseOrUnwise(candidate);
        }

        currentSmallestCpc = Cheetah.state.selection.selectedItem.cpc;
        if (candidate.cpc < currentSmallestCpc) {
            better = candidate;
            worse = Cheetah.state.selection.selectedItem;
            if (Cheetah.compare.items(better, worse)) {
                return Cheetah.select.wiseOrUnwise(candidate);
            }
        } else {
            better = Cheetah.state.selection.selectedItem;
            worse = candidate;
            if (!Cheetah.compare.items(better, worse)) {
                return Cheetah.select.wiseOrUnwise(candidate);
            }
        }

        return false;
    },

    elder: {
        achievementUpgrade: function () {
            "use strict";

            if (Cheetah.select.elder.covenant()) {
                return true;
            }

            if (Cheetah.select.elder.revokeCovenant()) {
                return true;
            }

            if (Cheetah.select.elder.appeasement()) {
                return true;
            }

            return false;
        },

        appeasement: function () {
            "use strict";

            // pledge pops wrinklers, so hold off buying until elder frenzy over
            if (Game.frenzy && Game.frenzyPower === 666) {
                return false;
            }

            if (Cheetah.select.sacrificialRollingPins()) {
                return true;
            }

            if (Cheetah.select.elder.pledge()) {
                return true;
            }

            return false;
        },

        covenant: function () {
            "use strict";

            if (!Game.Upgrades["Elder Covenant"].unlocked) {
                return false;
            }

            if (Game.Upgrades["Elder Covenant"].bought) {
                return false;
            }

            if (!Game.Achievements["Elder calm"].won) {
                Cheetah.select.item(Game.Upgrades["Elder Covenant"]);
                return true;
            }

            if (!Game.pledgeT) {
                return false;
            }

            if (!Game.Achievements["Elder slumber"].won) {
                Cheetah.select.item(Game.Upgrades["Elder Covenant"]);
                return true;
            }

            return false;
        },

        pledge: function () {
            "use strict";
            if (!Game.Upgrades["Elder Pledge"].unlocked) {
                return false;
            }

            if (Game.pledgeT) {
                return false;
            }

            Cheetah.select.item(Game.Upgrades["Elder Pledge"]);
            return true;
        },

        research: function () {
            "use strict";
            var candidate, i, unbought, unlocked;

            for (i = 70; i < 75; i += 1) {
                candidate = Game.UpgradesById[i];
                unbought = !candidate.bought;
                unlocked = candidate.unlocked;
                if (unbought && unlocked) {
                    if (i === 71) {
                        if (Cheetah.select.object.roundBundle(1, 50)) {
                            return true;
                        }
                    }
                    if (i === 73) {
                        if (Cheetah.select.object.roundBundle(7, 20)) {
                            return true;
                        }
                    }
                    Cheetah.select.item(candidate);
                    return true;
                }
            }

            return false;
        },

        revokeCovenant: function () {
            "use strict";
            if (!Game.Upgrades["Revoke Elder Covenant"].unlocked) {
                return false;
            }
            if (Game.Upgrades["Elder Pledge"].unlocked) {
                return false;
            }
            Cheetah.select.item(Game.Upgrades["Revoke Elder Covenant"]);
            return true;
        }
    },

    elders: function () {
        "use strict";
        var christmasExhausted, valentinesExhausted;

        if (Cheetah.select.elder.achievementUpgrade()) {
            return true;
        }

        if (Cheetah.state.enterGrandmapocalypse()) {

            // select One mind and beyond when available
            if (Cheetah.select.grandmapocalypse()) {
                return true;
            }
        }

        christmasExhausted = (!Cheetah.count.lockedUpgrades.christmas());
        valentinesExhausted = (!Cheetah.count.lockedUpgrades.valentines());

        if (Cheetah.state.exitGrandmapocalypse()) {
            // select appeasement when available
            if (Cheetah.select.elder.appeasement()) {
                return true;
            }

            // select researched upgrades to bring up pledge. in practice
            // it is unlikely to reach this, as the pledge will most likely
            // have been brought up (by the normal upgrade selector) already
            // by the time all halloween upgrades are unlocked.
            if (Cheetah.select.elder.research()) {
                return true;
            }

        // if it is not Grandmapocalypse and seasons apart from halloween
        // have been exhausted, speed up research to get to Grandmapocalypse
        } else if (christmasExhausted && valentinesExhausted) {
            if (Cheetah.select.elder.research()) {
                return true;
            }
        }

        return false;
    },

    // select first available golden cookies upgrade affordable or below the
    // price of current selection
    goldenUpgrade: function () {
        "use strict";
        var candidate, candidates, i;
        candidates = Cheetah.constants.upgrades.golden;
        for (i = 0; i < candidates.length; i += 1) {
            candidate = candidates[i];
            if (Cheetah.state.selectable.upgrade.golden(candidate)) {
                Cheetah.select.item(candidate);
                return true;
            }
        }

        return false;
    },

    grandmapocalypse: function () {
        "use strict";

        if (Cheetah.select.persistentMemory()) {
            return true;
        }

        return Cheetah.select.oneMind();
    },

    // feed me Selectables or game objects
    item: function (s) {
        "use strict";
        var w;

        if (s.name === "Santa Level Up") {
            s = new Cheetah.Selectable(s);
        }

        if (s instanceof Game.Upgrade || s instanceof Game.Object) {
            s = new Cheetah.Selectable(s);
        }

        if (!(s instanceof Cheetah.Selectable)) {
            w = "WARNING: non-selectable item set to select. This will break ";
            w += "all the things.";
            Cheetah.debug.log(w);
        }

        Cheetah.state.selection.selectedItem = s;
        Cheetah.state.selection.done = true;
        Cheetah.state.selection.time = Date.now();
        Cheetah.state.selection.cpsAtTheTime = Game.cookiesPs;

        return true;
    },

    object: {
        bundle: function (i) {
            "use strict";
            var b, cpc, cps, getPrice, item, oups, price, up, ups;

            up = Cheetah.select.object.upgrade(i);
            if (!up) {
                return false;
            }

            oups = Cheetah.constants.objectUpgrades;
            b = new Cheetah.BuildingBundle(i, oups[i][up]);

            getPrice = Cheetah.count.price.for.object.bundle;
            price = getPrice(i, b.amount);
            if (price === 0) {
                return false;
            }

            ups = Cheetah.constants.upgrades;
            price += ups[up].getPrice();

            cps = Cheetah.count.cps.gain.from.buildingsAndUpgrade(b, ups[up]);
            cpc = price / cps;
            item = new Cheetah.Selectable(
                b.object,
                cpc,
                cps,
                price,
                b.amount,
                ups[up]
            );
            return Cheetah.select.comparativelyBetter(item);
        },

        number: function (i) {
            "use strict";
            Cheetah.select.object.bundle(i);
            Cheetah.select.object.unit(i);
        },

        roundBundle: function (id, n) {
            "use strict";
            var amount, b, cpc, cps, limit, price, purchaseTime, s;

            amount = n - Game.ObjectsById[id].amount % n;
            if (10 * amount / n > 3) { // a wild 30 % appears!
                return false;
            }

            limit = Cheetah.config.reasonableWaitingTime;
            n = Game.ObjectsById[id].amount + amount;
            b = new Cheetah.BuildingBundle(id, n);
            purchaseTime = Cheetah.count.time.till.purchaseOfBuildingBundle(b);
            if (Math.floor(purchaseTime) > limit) {
                return false;
            }

            price = Cheetah.count.price.for.object.bundle(id, amount);
            cps = Cheetah.count.cps.gain.from.buildingBundle(b);
            cpc = price / cps;
            b = Game.ObjectsById[id];
            s = new Cheetah.Selectable(b, cpc, cps, price, amount);
            Cheetah.select.item(s);

            return true;

        },

        // select most cps-wise valuable building available if better than
        // current selection
        unit: function (i) {
            "use strict";
            var candidate, cpc, cps, price, item;

            candidate = Game.ObjectsById[i];
            price = candidate.getPrice();
            cps = Cheetah.count.cps.gain.from.building(candidate);
            cpc = price / cps;
            item = new Cheetah.Selectable(candidate, cpc, cps, price);

            return Cheetah.select.comparativelyBetter(item);
        },

        // select first still locked upgrade achievable by buying buildings
        upgrade: function (i) {
            "use strict";
            var oups, up, ups, w;

            if (i >= Cheetah.constants.objectUpgrades.length) {
                w = "WARNING: objectUpgrades index out of bounds ";
                w += "(game has a new building?).";
                Cheetah.debug.log(w);
                return false;
            }

            oups = Cheetah.constants.objectUpgrades[i];
            ups = Cheetah.constants.upgrades;
            for (up in oups) {
                if (oups.hasOwnProperty(up)) {
                    if (!ups.hasOwnProperty(up)) {
                        w = "WARNING: objectUpgrades has unknown upgrade ";
                        w += "\"" + up + "\".";
                        Cheetah.debug.log(w);
                        return false;
                    }

                    if (!ups[up].unlocked) {
                        return up;
                    }
                }
            }

            return false;
        }
    },

    oneMind: function () {
        "use strict";
        var unbought, unlocked;

        unbought = !Game.Upgrades["One mind"].bought;
        unlocked = Game.Upgrades["One mind"].unlocked;
        if (unbought && unlocked) {
            if (Cheetah.select.object.roundBundle(1, 50)) {
                return true;
            }

            Cheetah.select.item(Game.Upgrades["One mind"]);
            return true;
        }

        return false;
    },

    // the master purchase selector which calls all the other ones. something
    // will always get selected, so no sense returning values from here.
    optimalItem: function () {
        "use strict";

        Cheetah.state.selection.initialize();

        if (Cheetah.select.season.change()) {
            return;
        }

        // deal with Grandmapocalypse
        if (Cheetah.select.elders()) {
            return;
        }

        // experimental purchase of single object, for achievements
        if (Cheetah.select.singular()) {
            return;
        }

        // prefer non-cpc santa drops (cheaper buildings etc.)
        if (Cheetah.select.santaDrop()) {
            return;
        }

        // select cpc-wise best upgrade or building
        Cheetah.select.upgrade();
        Cheetah.select.building();

        // highly prefer santa upgrades. even with Santa's legacy these will not
        // be very cpc-worthy, but the drops will be valuable.
        if (Cheetah.select.santaUpgrade()) {
            return;
        }

        // prefer non-cps egg upgrades.
        if (Cheetah.select.easterUpgrade()) {
            return;
        }

        // prefer golden cookie upgrades over the rest
        if (Cheetah.select.goldenUpgrade()) {
            return;
        }
    },

    persistentMemory: function () {
        "use strict";
        var persistentMemory, reachable, unbought, unlocked;

        persistentMemory = Game.Upgrades["Persistent memory"];
        reachable = Cheetah.state.reachable(persistentMemory.getPrice());
        unbought = !persistentMemory.bought;
        unlocked = persistentMemory.unlocked;
        if (unbought && unlocked && reachable) {
            Cheetah.select.item(persistentMemory);
            return true;
        }

        return false;
    },

    sacrificialRollingPins: function () {
        "use strict";
        var rollingPins;

        rollingPins = Game.Upgrades["Sacrificial rolling pins"];

        if (!rollingPins.unlocked) {
            return false;
        }

        if (rollingPins.bought) {
            return false;
        }

        if (!Cheetah.state.reachable(rollingPins.getPrice())) {
            return false;
        }

        Cheetah.select.item(rollingPins);
        return true;
    },

    // select first available non-cps santa drop
    santaDrop: function () {
        "use strict";
        var candidate, candidates, i;

        candidates = Cheetah.constants.upgrades.santaDrops.nonCps;

        for (i = 0; i < candidates.length; i += 1) {
            candidate = candidates[i];
            if (Cheetah.state.selectable.upgrade.santaDrop(candidate)) {
                Cheetah.select.item(candidate);
                return true;
            }
        }

        return false;
    },

    // select next santalevel
    santaLevelUp: function () {
        "use strict";
        var cpc, cps, levelUp, price;

        if (!Game.Upgrades["A festive hat"].bought) {
            return false;
        }

        if (!Cheetah.state.levelUpSanta()) {
            return false;
        }

        levelUp = Cheetah.constants.upgrades.santaLevel.get();
        price = levelUp.getPrice();
        cps = Cheetah.count.cps.gain.from.santaLevelUp();
        if (cps) {
            cpc = price / cps;
        } else {
            cpc = 0;
        }

        Cheetah.select.item(levelUp, cpc, cps, price);
        return true;
    },

    // select a non-cps rare egg
    easterUpgrade: function () {
        "use strict";
        var e;

        e = Game.Upgrades["Faberge egg"];
        if (e.unlocked && !e.bought) {
            Cheetah.select.item(e);
            return true;
        }

        e = Game.Upgrades.Omelette;
        if (e.unlocked && !e.bought) {
            Cheetah.select.item(e);
            return true;
        }

        if (!Cheetah.state.grandmapocalypse()) {
            return false;
        }

        e = Game.Upgrades.Wrinklerspawn;
        if (e.unlocked && !e.bought) {
            Cheetah.select.item(e);
            return true;
        }

        return false;
    },

    // select A festive hat, or next santalevel
    santaUpgrade: function () {
        "use strict";

        if (Game.santaLevel >= Cheetah.constants.santaLevels) {
            return false;
        }

        if (Cheetah.select.aFestiveHat()) {
            return true;
        }

        if (Cheetah.select.santaLevelUp()) {
            return true;
        }

        return false;
    },

    season: {

        // select season changing upgrade when sensible
        change: function () {
            "use strict";
            var choice, pickSeason;

            if (Cheetah.debug.newSeasonStopper()) {
                return false;
            }

            pickSeason = Cheetah.select.season;

            choice = pickSeason.switcher();
            if (choice !== null) {
                return choice;
            }

            choice = pickSeason.halloween();
            if (choice !== null) {
                return choice;
            }

            if (Cheetah.state.stayInCurrentSeason()) {
                return false;
            }

            choice = pickSeason.easter();
            if (choice !== null) {
                return choice;
            }

            choice = pickSeason.valentines();
            if (choice !== null) {
                return choice;
            }

            choice = pickSeason.christmas();
            if (choice !== null) {
                return choice;
            }

            return false;
        },

        // select cheapest season changing upgrade available
        cheapest: function () {
            "use strict";
            var cheapest, cheapestSelected, price, s, seasons, selectable;

            seasons = Cheetah.constants.upgrades.seasons;
            selectable = Cheetah.state.selectable.upgrade.season;
            for (s = 0; s < seasons.length; s += 1) {
                price = seasons[s].getPrice;
                if (!cheapestSelected) {
                    cheapestSelected = seasons[s];
                } else {
                    cheapest = (cheapestSelected.getPrice() > price);
                    if (cheapest && selectable(price)) {
                        cheapestSelected = seasons[s];
                    }
                }
            }

            if (!cheapestSelected) {
                return false;
            }

            Cheetah.select.item(cheapestSelected);

            return true;
        },

        christmas: function () {
            "use strict";
            var christmas, log;

            if (Game.season === "christmas") {
                return false;
            }

            christmas = Cheetah.constants.upgrades.seasonsByName.christmas;
            if (!Cheetah.state.selectable.upgrade.season(christmas)) {
                return Cheetah.select.season.cheapest();
            }

            log = christmas.getPrice();
            log = Cheetah.beautify.short(log);
            log = "Selecting Christmas (@ " + log + ").";
            Cheetah.debug.log(log);

            Cheetah.select.item(christmas);

            return true;
        },

        // if valentine's unexhausted, make sure it is valentine's
        easter: function () {
            "use strict";
            var log, easter;

            if (Cheetah.state.achievements.won.for.easter()) {
                return null;
            }

            if (Game.season === "easter") {
                return false;
            }

            easter = Cheetah.constants.upgrades.seasonsByName.easter;
            if (!Cheetah.state.selectable.upgrade.season(easter)) {
                return null;
            }

            log = easter.getPrice();
            log = Cheetah.beautify.short(log);
            log = "Selecting Easter (@ " + log + ").";
            Cheetah.debug.log(log);

            Cheetah.select.item(easter);

            return true;
        },

        halloween: function () {
            "use strict";
            var halloween, log;

            if (!Cheetah.state.grandmapocalypse()) {
                return null;
            }

            if (Cheetah.state.achievements.won.for.halloween()) {
                return null;
            }

            if (Game.season === "halloween") {
                return false;
            }

            halloween = Cheetah.constants.upgrades.seasonsByName.halloween;
            if (!Cheetah.state.selectable.upgrade.season(halloween)) {
                return null;
            }

            log = halloween.getPrice();
            log = Cheetah.beautify.short(log);
            log = "Selecting Halloween (@ " + log + ").";
            Cheetah.debug.log(log);

            Cheetah.select.item(halloween);

            return true;
        },

        switcher: function () {
            "use strict";
            var reachable, seasonSwitcher, unbought, unlocked;

            seasonSwitcher = Game.Upgrades["Season switcher"];

            // if season switcher is not available, cannot pick anything
            unlocked = seasonSwitcher.unlocked;
            if (!unlocked) {
                return false;
            }

            // if season switcher is available but unbought, pick it. the 5k HC
            // should make this a breeze, unless cheating with instant purchase,
            // in which case reaching the switcher's price could also take ages
            // without cheating.
            unbought = !seasonSwitcher.bought;
            reachable = Cheetah.state.reachable(seasonSwitcher.getPrice());
            if (unbought && reachable) {
                Cheetah.select.item(seasonSwitcher);
                return true;
            }

            return null;
        },

        // if valentine's unexhausted, make sure it is valentine's
        valentines: function () {
            "use strict";
            var log, valentines;

            if (Cheetah.state.achievements.won.for.valentines()) {
                return null;
            }

            if (Game.season === "valentines") {
                return false;
            }

            valentines = Cheetah.constants.upgrades.seasonsByName.valentines;
            if (!Cheetah.state.selectable.upgrade.season(valentines)) {
                return null;
            }

            log = valentines.getPrice();
            log = Cheetah.beautify.short(log);
            log = "Selecting Valentine's (@ " + log + ").";
            Cheetah.debug.log(log);

            Cheetah.select.item(valentines);

            return true;
        }
    },

    singular: function () {
        "use strict";
        return Cheetah.singularSelection.select();
    },

    // if nothing is a wise choice, pick current unwise selection. reachability
    // might change thanks to wrinklers (see Game.Dissolve), but later
    // selection iterations will pick it up, so what this one picks does not
    // matter (all unwises are equally unwise).
    unwise: function () {
        "use strict";

        if (Cheetah.state.selection.done) {
            return;
        }

        if (Cheetah.state.selection.selectedUnwise === null) {
            return;
        }

        Cheetah.select.item(Cheetah.state.selection.selectedUnwise);
        Cheetah.state.selection.selectedUnwise = null;
    },

    unwiseItem: function (s) {
        "use strict";
        var f, w;

        if (s instanceof Game.Upgrade || s instanceof Game.Object) {
            s = new Cheetah.Selectable(s);
        }

        if (!(s instanceof Cheetah.Selectable)) {
            w = "WARNING: non-selectable item set to unwise select. This will ";
            w += "break all the things.";
            Cheetah.debug.log(w);
        }

        Cheetah.state.selection.selectedUnwise = s;
        if (Game.season === "fools" && s.gameObject.displayName) {
            f = Game.foolNames[s.name];
            Cheetah.state.selection.selectedUnwise.name = f;
        }
    },

    // select most cps-wise valuable regular upgrade available
    upgrade: function () {
        "use strict";
        var candidate, price, excluded, excludes, i, item, cpc, cps;

        excludes = Cheetah.constants.upgrades.excludedFromCpsSelector.slice();

        for (i = Game.UpgradesInStore.length - 1; i >= 0; i -= 1) {

            candidate = Game.UpgradesInStore[i];
            excluded = (excludes.indexOf(candidate.id) >= 0);

            if (!excluded) {
                price = candidate.getPrice();
                cps = Cheetah.count.cps.gain.from.upgrade(candidate);
                cpc = price / cps;

                item = new Cheetah.Selectable(candidate, cpc, cps, price);
                Cheetah.select.comparativelyBetter(item);
            }
        }

        Cheetah.select.unwise();
    },

    wiseOrUnwise: function (candidate) {
        "use strict";
        var bankable, reachable, unwise;

        bankable = Cheetah.state.bankable(candidate.price);
        reachable = Cheetah.state.reachable(candidate.price);
        unwise = Cheetah.state.selection.selectedUnwise;

        if (reachable && bankable) {
            Cheetah.select.item(candidate);
            return true;
        }

        if (Cheetah.compare.items(candidate, unwise)) {
            Cheetah.select.unwiseItem(candidate);
        }

        return false;
    }
};



Cheetah.sellOut = function () {
    "use strict";
    var i, gain, w;

    if (!Game.Upgrades["Chocolate egg"].unlocked) {
        return;
    }

    if (Game.Upgrades["Chocolate egg"].bought) {
        return;
    }

    gain = Game.cookiesEarned;
    for (i = 0; i < Game.ObjectsById.length; i += 1) {
        Game.ObjectsById[i].sell(-1);
    }
    if (Game.cookies < Game.Upgrades["Chocolate egg"].getPrice()) {
        w = "WARNING: could not afford to buy chocolate egg.";
        Cheetah.debug.log(w);
        return;
    }
    Game.Upgrades["Chocolate egg"].buy();
    gain = Cheetah.beautify.long(Game.cookiesEarned - gain);
    w = "Earned " + gain + " from chocolate egg sellout.";
    Cheetah.debug.log(w);
};



Cheetah.singularSelection = {
    active: false,
    amount: 200,
    reached: {
        with: {
            bank: function () {
                "use strict";
                var amount, item, price, w;

                if (!Cheetah.singularSelection.active) {
                    return false;
                }

                item = Cheetah.singularSelection.selectedItem;
                amount = Cheetah.singularSelection.amount - item.amount;
                price = Cheetah.count.price.for.object.bundle(item.id, amount);
                if (Game.cookies >= price) {
                    w = "Shorting bank to buy remaining " + item.plural;
                    w += ".";
                    Cheetah.debug.log(w);
                    return true;
                }

                return false;
            }
        }
    },
    select: function () {
        "use strict";
        var amount, cps, item, selectable;

        if (!Cheetah.singularSelection.active) {
            return false;
        }

        item = Cheetah.singularSelection.selectedItem;
        amount = item.amount;
        if (amount >= Cheetah.singularSelection.amount) {
            Cheetah.singularSelection.active = false;
            return false;
        }

        cps = Cheetah.count.cps.gain.from.building(item);
        selectable = new Cheetah.Selectable(
            item,
            item.getPrice() / cps,
            cps,
            item.getPrice()
        );

        Cheetah.select.item(selectable);
        Cheetah.singularSelection.sell.for();

        return true;
    },
    selectedItem: Game.ObjectsById[10],
    sell: {
        for: function () {
            "use strict";
            var amount, gain, gained, i, item, n, obs, price, s, skip, sold;

            s = Cheetah.singularSelection;
            item = s.selectedItem;
            if (item.getPrice() < Cheetah.count.cookies.inBank()) {
                return;
            }
            sold = [];
            gain = Cheetah.count.cookies.gained.from.sellingNth;
            obs = Game.ObjectsById;
            for (i = obs.length - 1; i >= 0; i -= 1) {
                sold.push(0);
            }
            skip = obs.indexOf(item);

            gained = 0;
            amount = s.amount - item.amount;
            price = Cheetah.count.price.for.object.bundle(item.id, amount);
            price -= Game.cookies;
            for (i = obs.length - 1; gained < price && i >= 0; i -= 1) {
                if (i !== skip) {
                    if (obs[i].amount > 0) {
                        for (n = 1; gained < price && n < item.amount; n += 1) {
                            gained += gain(n, i);
                        }
                        n = Math.max(item.amount, n);
                        sold[i] = n;
                    }
                }
            }
            if (gained >= price) {
                for (i = obs.length - 1; i >= 0; i -= 1) {
                    if (sold[i]) {
                        s.sell.object(i, sold[i]);
                    }
                }
            }
        },
        object: function (i, n) {
            "use strict";
            var w;
            w = "Selling " + n + " " + Game.ObjectsById[i].name + "s";
            Cheetah.debug.log(w);
            Game.ObjectsById[i].sell(n);
        }
    }
};

Cheetah.Cycler = function (max) {
    "use strict";
    this.last = 0;
    this.max = max;
    this.cycle = function () {
        var m, t;
        if (typeof this.max === "function") {
            m = this.max();
        } else {
            m = this.max;
        }
        t = Date.now();
        if (t - this.last >= m) {
            this.last = t;
            return true;
        }

        return false;
    };
};

Cheetah.state = {
    achievements: {
        attainable: {
            any: function () {
                "use strict";

                if (Cheetah.state.achievements.attainable.bake.any()) {
                    return true;
                }

                if (Cheetah.state.achievements.attainable.click.any()) {
                    return true;
                }

                if (Cheetah.state.achievements.attainable.cps.any()) {
                    return true;
                }

                if (Cheetah.state.achievements.attainable.elder.any()) {
                    return true;
                }

                if (Cheetah.state.achievements.attainable.haveObjects.any()) {
                    return true;
                }

                if (Cheetah.state.achievements.attainable.objectMade.any()) {
                    return true;
                }

                if (Cheetah.state.achievements.attainable.resetWith.any()) {
                    return true;
                }

                return false;
            },
            bake: {
                any: function () {
                    "use strict";
                    var b, i;
                    b = Cheetah.state.achievements.attainable.bake;
                    for (i = 0; i < Game.moneyAchievs.length / 2; i += 1) {
                        if (b.one(i)) {
                            return true;
                        }
                    }

                    return false;
                },
                one: function (i) {
                    "use strict";
                    var a, cps, limit, mass, needed;
                    a = Game.Achievements[Game.moneyAchievs[i * 2]];
                    if (a.won) {
                        return false;
                    }

                    mass = Game.moneyAchievs[i * 2 + 1];
                    needed = mass - Game.cookiesEarned;
                    cps = Cheetah.count.cps.total.current();
                    limit = Cheetah.config.reasonableWaitingTime;

                    return Math.floor(needed / cps) <= limit;
                }
            },
            click: {
                any: function () {
                    "use strict";
                    var a, b, i;

                    a = Cheetah.constants.achievements.click;
                    b = Cheetah.state.achievements.attainable.click;
                    for (i = a.length - 1; i >= 0; i -= 1) {
                        if (b.one(i)) {
                            return true;
                        }
                    }

                    return false;
                },
                one: function (i) {
                    "use strict";
                    var a, cps, limit, needed;

                    a = Cheetah.constants.achievements.click;
                    if (Game.Achievements[a[i]].won) {
                        return false;
                    }

                    needed = 1000 * Math.pow(100, i);
                    needed -= Game.handmadeCookies;
                    cps = Cheetah.count.cps.autoclick();

                    limit = Cheetah.config.reasonableWaitingTime;

                    return Math.floor(needed / cps) <= limit;
                }
            },
            cps: {
                any: function () {
                    "use strict";
                    var b, i;

                    b = Cheetah.state.achievements.attainable.cps;
                    for (i = 0; i < Game.cpsAchievs.length / 2; i += 1) {
                        if (b.one(i)) {
                            return true;
                        }
                    }

                    return false;
                },
                one: function (i) {
                    "use strict";
                    var a, cps, limit, mass, needed;

                    a = Game.Achievements[Game.cpsAchievs[i * 2]];
                    if (a.won) {
                        return false;
                    }

                    if (!Cheetah.state.selection.done) {
                        return false;
                    }

                    if (Cheetah.state.selection.selectedItem.cps === 0) {
                        return false;
                    }

                    mass = Game.cpsAchievs[i * 2 + 1];
                    cps = Cheetah.count.cps.raw();
                    needed = mass - cps;

                    if (needed > Cheetah.state.selection.selectedItem.cps) {
                        return false;
                    }

                    limit = Cheetah.config.reasonableWaitingTime;

                    return Cheetah.count.time.till.purchase() <= limit;
                }
            },
            elder: {
                any: function () {
                    "use strict";
                    var a, i;

                    if (!Cheetah.state.enterGrandmapocalypse()) {
                        return false;
                    }

                    a = Cheetah.constants.achievements.elder;
                    for (i in a) {
                        if (a.hasOwnProperty(i)) {
                            if (!Game.Achievements[i].won) {
                                return true;
                            }
                        }
                    }

                    return false;
                }
            },
            haveObjects: {
                any: function () {
                    "use strict";
                    var ho;
                    ho = Cheetah.state.achievements.attainable.haveObjects;
                    if (ho.oneType.any()) {
                        return true;
                    }

                    // look for the "this is not quite so simple" comment
                    // elsewhere in this file.
                    // return ho.anyType.any();
                    return false;
                },
                oneType: {
                    any: function () {
                        "use strict";
                        var ho, i;

                        ho = Cheetah.state.achievements.attainable.haveObjects;
                        ho = ho.oneType;
                        for (i = 0; i < Game.ObjectsById.length; i += 1) {
                            if (ho.one(i)) {
                                return true;
                            }
                        }

                        return false;
                    },
                    one: function (i) {
                        "use strict";
                        var a, ho, j, name, n;

                        a = Cheetah.constants.achievements.haveObjects.oneType;
                        ho = Cheetah.state.achievements.attainable.haveObjects;
                        ho = ho.oneType;
                        for (j = 0; j < a[i].list.length; j += 1) {
                            name = a[i].list[j];
                            n = a[i].objectsNeeded[j];
                            if (ho.onePerObject(i, name, n)) {
                                return true;
                            }
                        }

                        return false;
                    },
                    onePerObject: function (i, name, n) {
                        "use strict";
                        var cps, limit, price;

                        if (Game.Achievements[name].won) {
                            return false;
                        }

                        price = Cheetah.count.price.for.object.bundle(i, n);
                        cps = Cheetah.count.cps.total.current();
                        limit = Cheetah.config.reasonableWaitingTime;

                        return Math.floor(price / cps) <= limit;
                    }
                }
            },
            objectMade: {
                any: function () {
                    "use strict";
                    var i, j;

                    j = Cheetah.state.achievements.attainable.objectMade;
                    for (i = 0; i < Game.ObjectsById.length; i += 1) {
                        if (j.one(i)) {
                            return true;
                        }
                    }

                    return false;
                },
                one: function (i) {
                    "use strict";
                    var cps, limit, name, made, om, needed;

                    om = Cheetah.constants.achievements.objectMade;
                    name = om.list[i];
                    if (Game.Achievements[name].won) {
                        return false;
                    }

                    made = Game.ObjectsById[i].totalCookies;
                    needed = om.cookiesNeeded[i] - made;
                    cps = Game.ObjectsById[i].storedTotalCps;
                    limit = Cheetah.config.reasonableWaitingTime;

                    return Math.floor(needed / cps) <= limit;
                }
            },
            resetWith: {
                any: function () {
                    "use strict";
                    var a, i, r;

                    a = Cheetah.constants.achievements.resetWith;
                    r = Cheetah.state.achievements.attainable.resetWith;
                    for (i = 0; i < a.length; i += 1) {
                        if (r.one(i)) {
                            return true;
                        }
                    }

                    return false;
                },
                one: function (i) {
                    "use strict";
                    var a, cps, limit, needed;

                    a = Cheetah.constants.achievements.resetWith;
                    if (Game.Achievements[a[i]].won) {
                        return false;
                    }

                    needed = 1000000 * Math.pow(1000, i) - Game.cookiesEarned;

                    // won already; turn our eyes on the next one.
                    if (needed < 0) {
                        return false;
                    }

                    cps = Cheetah.count.cps.total.current();
                    limit = Cheetah.config.reasonableWaitingTime;

                    return Math.floor(needed / cps) <= limit;
                }
            }
        },

        initialize: function () {
            "use strict";
            Cheetah.state.achievements.won.initialize();
        },

        won: {
            easy: false,
            for: {
                christmas: function () {
                    "use strict";
                    var as, i;

                    as = [
                        "Coming to town",
                        "All hail Santa",
                        "Let it snow",
                        "Oh deer",
                        "Sleigh of hand",
                        "Reindeer sleigher"
                    ];

                    for (i = 0; i < as.length; i += 1) {
                        if (!Game.Achievements[as[i]].won) {
                            return false;
                        }
                    }
                    return true;
                },
                easter: function () {
                    "use strict";
                    if (!Game.Achievements["Hide & seek champion"].won) {
                        return false;
                    }
                    return true;
                },
                halloween: function () {
                    "use strict";
                    if (!Game.Achievements.Moistburster.won) {
                        return false;
                    }

                    if (Game.Achievements["Spooky cookies"].won) {
                        return true;
                    }

                    return false;
                },
                valentines: function () {
                    "use strict";
                    if (Game.Achievements["Lovely cookies"].won) {
                        return true;
                    }

                    return false;
                }
            },
            initialize: function () {
                "use strict";
                Cheetah.state.achievements.won.easy = false;
            }
        }
    },

    // on/off for autobuy, keypress ("a") togglable
    autoBuy: true,

    bakeryNameActive: function () {
        "use strict";
        var n;

        if (!document.activeElement.id) {
            return false;
        }

        n = Cheetah.constants.elements.bakeryNameInput.id;
        if (document.activeElement.id === n) {
            return true;
        }

        return false;
    },

    bankable: function (p) {
        "use strict";
        var unluckyBank;

        // "awoken" still gives 2:1 ratio of golden vs. red cookies,
        // so "lucky" cookies are more likely than "ruin" cookies
        if (Game.elderWrath < 2) {
            return true;
        }

        // when 5 % of cookies to bank (to buy item) is more than 10 minutes
        // worth of production, "ruin" causes loss of those 10 minutes' worth,
        // so banking a lesser value means losing that lesser value in "ruin".
        unluckyBank = 600 * Game.cookiesPs;
        return (0.05 * p <= unluckyBank);
    },

    bankShortingSelected: function () {
        "use strict";
        var i, s;

        if (!Cheetah.state.selection.selectedItem) {
            return false;
        }

        s = Cheetah.constants.upgrades.bankShorting;

        for (i = 0; i < s.length; i += 1) {
            if (Cheetah.state.selection.selectedItem.gameObject === s[i]) {
                return true;
            }
        }

        return false;
    },

    // true when banking cookies
    bankingCookies: function () {
        "use strict";

        if (!Game.Upgrades["Get lucky"].bought) {
            return false;
        }

/*
        // "awoken" still gives 2:1 ratio of golden vs. red cookies
        if (Game.elderWrath > 1) {
            return false;
        }
*/

        if (Cheetah.state.bankShortingSelected()) {
            return false;
        }

        if (Game.cookies >= Cheetah.count.luckyBank()) {
            return false;
        }

        if (Cheetah.compare.purchaseToBanking()) {
            return false;
        }

        return true;
    },

    bankReachedWithWrinklerPops: function () {
        "use strict";
        var cookiesInBank, suckedReturns;

        if (!Cheetah.state.bankingCookies()) {
            return false;
        }

        cookiesInBank = Cheetah.count.cookies.inBank();
        if (cookiesInBank >= 0) {
            return false;
        }

        suckedReturns = Cheetah.count.cookies.gained.from.poppingWrinklers();

        if (!suckedReturns) {
            return false;
        }

        return (cookiesInBank + suckedReturns >= 0);
    },

    bigClick: {
        time: Date.now(),
        remainder: 0
    },

    // true when it is time to purchase selected item.
    buy: function () {
        "use strict";
        var price, selected;

        if (!Cheetah.state.selection.done) {
            return false;
        }

        if (!Cheetah.state.autoBuy) {
            return false;
        }

        if (Cheetah.debug.autoInstantBuy()) {
            Cheetah.debug.gainCookiesForInstantBuy(true);
            return true;
        }

        selected = Cheetah.state.selection.selectedItem;
        if (selected.upgrade) {
            price = selected.gameObject.getPrice();
        } else {
            price = selected.price;
        }

        if (Cheetah.singularSelection.reached.with.bank()) {
            return true;
        }

        if (Cheetah.count.cookies.inBank() < price) {
            return false;
        }

        return true;
    },

    // true when it is time to click something
    click: {
        popupCookie: function () {
            "use strict";
            var christmas, cr, clickFrenzyMaxTime;

            if (Game.goldenCookie.life === 0) {
                return false;
            }

            cr = Cheetah.config.clickRedCookies;
            cr = cr || Game.goldenCookie.wrath === 0;

            if (Game.goldenCookie.life === 1) {
                return cr;
            }

            // I do not think this ever actually happens.
            if (Game.clickFrenzy) {
                return cr;
            }

            if (Game.frenzy === 0 || Game.frenzyPower < 1) {
                christmas = (Game.season === "christmas");
                if (Game.seasonPopup.life || !christmas) {
                    return cr;
                }
                return false;
            }

            // main.js:1949 (Cheetah.constants.compatibleGameVersion)
            clickFrenzyMaxTime = (13 + 13 * Game.Has("Get lucky")) * Game.fps;
            if (Game.frenzy < clickFrenzyMaxTime + 2) {
                return cr;
            }

            return false;
        },

        reindeer: function () {
            "use strict";
            var t;

            if (Game.seasonPopup.life === 0) {
                return false;
            }

            if (Game.seasonPopup.life < 2) {
                return true;
            }

            if (!Game.frenzy) {
                return false;
            }

            if (Game.frenzyPower < 1) {
                return false;
            }

            if (Game.frenzy < 3) {
                return true;
            }

            t = Game.seasonPopup.life / Game.fps;
            if (Cheetah.count.time.till.purchase() >= t) {
                return true;
            }

            return false;
        },

        wrinklers: function () {
            "use strict";
            var item, log, price;

            if (!Cheetah.state.grandmapocalypse()) {
                return false;
            }

            if (Game.frenzy > 0 && Game.frenzyPower > 1) {
                return false;
            }

            if (!Game.Achievements.Moistburster.won) {
                return true;
            }

            if (Cheetah.state.bankReachedWithWrinklerPops()) {
                price = Cheetah.count.luckyBank();
                price = Cheetah.beautify.long(price);
                log = "Popping wrinklers to reach bank of " + price;
                Cheetah.debug.log(log);

                return true;
            }

            if (Cheetah.state.priceReachedWithWrinklerPops()) {
                price = Cheetah.state.selection.selectedItem.price;
                price = Cheetah.beautify.long(price);
                log = price;
                item = Cheetah.state.selection.selectedItem.name;
                item += " (" + log + ")";
                log = "Popping wrinklers to reach price of " + item;
                Cheetah.debug.log(log);
                return true;
            }

            return false;
/*
            if (!Cheetah.state.halloweenCookiesAvailable()) {
                return popToBuy;
            }

            if (!Cheetah.count.lockedUpgrades.halloween()) {
                return popToBuy;
            }

            return popToBuy;
*/
        }
    },

    // true when it is time to buy One mind.
    // http://redd.it/24djlv#siteTable_t3_24djlv
    enterGrandmapocalypse: function () {
        "use strict";

        if (!Cheetah.state.halloweenCookiesAvailable()) {
            return false;
        }

        return true;
    },

    // true when it is time to exit grandmapocalypse
    exitGrandmapocalypse: function () {
        "use strict";
        if (!Cheetah.state.grandmapocalypse()) {
            return false;
        }

        if (!Cheetah.state.halloweenCookiesAvailable()) {
            return true;
        }

        if (!Game.Achievements.Moistburster.won) {
            return false;
        }

        if (!Cheetah.count.lockedUpgrades.halloween()) {
            return true;
        }

        if (Game.Achievements["Spooky cookies"].won) {
            return true;
        }

        return false;
    },

    goForNeverclick: false,

    grandmapocalypse: function () {
        "use strict";
        return (Game.elderWrath > 0);
    },

    // reselection is forced once/max mseconds during grandmapocalypse.
    // returns true when it is time to select.
    grandmapocalypseSelect: function () {
        "use strict";
        return Cheetah.state.cycles.grandmapocalypseSelect.cycle();
    },

    // Season switcher becomes available at 5k HC. without it, unless it is
    // halloween by default, halloween cookies will not be available.
    halloweenCookiesAvailable: function () {
        "use strict";
        var switcherIsAvailable, baseSeasonIsHalloween;

        switcherIsAvailable = (Game.prestige["Heavenly chips"] >= 5000);
        baseSeasonIsHalloween = (Game.baseSeason === "halloween");

        return (switcherIsAvailable || baseSeasonIsHalloween);
    },

    importing: false,

    initialize: function () {
        "use strict";

        // holds off reset until hijacked buy functions returned
        Cheetah.state.hijackedFunctions = false;

        Cheetah.state.selection.initialize();

        Cheetah.state.achievements.initialize();

        Cheetah.state.goForNeverclick = (function () {

            if (Game.Achievements.Neverclick.won) {
                return false;
            }

            if (Game.prestige["Heavenly chips"] < 5000) {
                return false;
            }

            if (Game.cookiesEarned === 0) {
                return true;
            }

            if (Game.cookieClicks === 0) {
                return true;
            }

            return false;
        }());

    },

    // HC gained at last reset; not truthful until next reset
    lastHeavenlyChipsGained: 0,

    // true when santa level up should be bought
    levelUpSanta: function () {
        "use strict";
        var cps, levelUp, price;

        if (Game.santaLevel >= Cheetah.constants.santaLevels) {
            return false;
        }

        levelUp = Cheetah.constants.upgrades.santaLevel.get();
        price = levelUp.getPrice();
        if (!Cheetah.state.reachable(price)) {
            return false;
        }

        cps = Cheetah.count.cps.total.current();
        if (price / cps > Cheetah.config.reasonableWaitingTime) {
            return false;
        }

        if (Game.Upgrades["Santa's legacy"].bought) {
            return true;
        }

        if (price < Cheetah.count.cookies.inBank()) {
            return true;
        }

        if (!Cheetah.state.selection.done) {
            return true;
        }

        if (Cheetah.state.selection.selectedItem.price < price) {
            return false;
        }

        return true;
    },

    neverclicked: false,

    // true when there is nothing special from golden cookies going on
    noFrenzy: function () {
        "use strict";
        return (Game.frenzy === 0 && Game.goldenCookie.chain === 0);
    },

    priceReachedWithWrinklerPops: function () {
        "use strict";
        var cookiesInBank, price, suckedReturns;

        if (!Cheetah.state.selection.done) {
            return false;
        }

        price = Cheetah.state.selection.selectedItem.price;
        cookiesInBank = Cheetah.count.cookies.inBank();
        if (cookiesInBank >= price) {
            return false;
        }

        suckedReturns = Cheetah.count.cookies.gained.from.poppingWrinklers();

        if (!suckedReturns) {
            return false;
        }

        return (cookiesInBank + suckedReturns > price);
    },

    reachable: function (p) {
        "use strict";
        var remainingToGain;

        if (!Cheetah.config.autoReset) {
            return true;
        }

        remainingToGain = Cheetah.count.cookies.remainingToGainFor.reset();

        return (p < remainingToGain);
    },

    // true if "time to reset?" should be checked (note: it does not answer the
    // question "time to reset?" itself)
    resetCheck: function () {
        "use strict";

        if (!Cheetah.config.autoReset) {
            return false;
        }

        if (Game.version > Cheetah.constants.compatibleGameVersion) {
            return false;
        }

        if (Cheetah.state.resetting) {
            return false;
        }

        if (Cheetah.state.neverclicked) {
            return true;
        }

        if (!Cheetah.state.noFrenzy()) {
            return false;
        }

        return true;
    },

    resetting: false,

    // returns true when current season began more than given seconds ago
    seasonOlderThanSeconds: function (s) {
        "use strict";
        var dayFrames, hourFrames, limitInFrames, minuteFrames;

        dayFrames = Game.fps * 60 * 60 * 23;
        hourFrames = Game.fps * 60 * 59;
        minuteFrames = Game.fps * (60 - s);
        limitInFrames = dayFrames + hourFrames + minuteFrames;

        return Game.seasonT < limitInFrames;
    },

    // true when it is time to select a new item to aim for
    select: function () {
        "use strict";
        var selected;

        if (!Cheetah.state.selection.done) {
            return true;
        }

        selected = Cheetah.state.selection.selectedItem;

        if (selected === null) {
            return true;
        }

        if (!selected.hasOwnProperty("gameObject")) {
            return true;
        }

        if (typeof selected.gameObject !== "object") {
            return true;
        }

        if (Cheetah.debug.forcedSelection) {
            Cheetah.debug.forcedSelection = false;
            return true;
        }

        if (Cheetah.state.selection.cpsAtTheTime !== Game.cookiesPs) {
            return true;
        }

        if (Cheetah.state.bankingCookies()) {
            return false;
        }

        if (Cheetah.state.selectionExpired()) {
            return true;
        }

        return false;
    },

    // true when current selection is so old it needs to be refreshed
    // (just to be sure)
    selectionExpired: function () {
        "use strict";
        var selectionAge, selectionAgeLimit, selectionTime, timeNow;

        selectionTime = Cheetah.state.selection.time;
        if (selectionTime < 0) {
            return true;
        }

        timeNow = Date.now();
        selectionAge = timeNow - selectionTime;
        selectionAgeLimit = Cheetah.config.selection.ageLimit;

        return selectionAge > selectionAgeLimit;
    },

    // true when given item is selectable
    selectable: {
        upgrade: {

            // true if price already reached,
            // or if existing selection is more expensive
            affordable: function (candidate) {
                "use strict";
                var price;
                price = Math.round(candidate.getPrice());

                if (candidate.bought) {
                    return false;
                }

                if (!candidate.unlocked) {
                    return false;
                }

                if (Cheetah.count.cookies.inBank() >= price) {
                    return true;
                }

                if (Cheetah.state.selection.selectedItem.price > price) {
                    return true;
                }

                return false;
            },
            affordableReachable: function (candidate) {
                "use strict";
                var affordable, reachable;

                affordable = Cheetah.state.selectable.upgrade.affordable;
                affordable = affordable(candidate);
                reachable = Cheetah.state.reachable(candidate.getPrice());

                return (affordable && reachable);
            },
            golden: function (candidate) {
                "use strict";
                var selectable;
                selectable = Cheetah.state.selectable;
                return selectable.upgrade.affordableReachable(candidate);
            },
            santaDrop: function (candidate) {
                "use strict";
                var selectable;
                selectable = Cheetah.state.selectable;
                return selectable.upgrade.affordableReachable(candidate);
            },
            season: function (season) {
                "use strict";
                var reachable, unlocked;

                reachable = Cheetah.state.reachable(season.getPrice());
                unlocked = season.unlocked;

                return (reachable && unlocked);
            }
        }
    },

    selection: {
        cpsAtTheTime: -1,
        done: false,
        initialize: function () {
            "use strict";
            Cheetah.state.selection.cpsAtTheTime = -1;
            Cheetah.state.selection.done = false;
            Cheetah.state.selection.selectedItem = null;
            Cheetah.state.selection.time = -1;
            Cheetah.state.selection.selectedUnwise = null;
        },
        selectedItem: null,
        time: -1,
        selectedUnwise: null
    },

    stayInCurrentSeason: function () {
        "use strict";

        if (!Cheetah.count.lockedUpgrades.currentSeason()) {
            return false;
        }

        switch (Game.season) {
        case "halloween":
            return !Cheetah.state.achievements.won.for.halloween();
        case "easter":
            return Cheetah.state.stayInEaster();
        case "valentines":
            return !Cheetah.state.achievements.won.for.valentines();
        case "christmas":
            return !Cheetah.state.achievements.won.for.christmas();
        case "":
            return false;
        default:
            return true;
        }
    },

    stayInEaster: function () {
        "use strict";
        var eggsRemaining;

        // main.js:4685 (Cheetah.constants.compatibleGameVersion)
        if (!Game.Has("Santa's bottomless bag")) {
            return false;
        }

        if (!Cheetah.state.achievements.won.for.easter()) {
            return true;
        }

        if (Cheetah.count.lockedUpgrades.eggs.good()) {
            return true;
        }

        eggsRemaining = Cheetah.count.lockedUpgrades.eggs.common();
        if (!eggsRemaining) {
            return false;
        }

        if (eggsRemaining <= Cheetah.config.eggCutOff) {
            return true;
        }

        return false;
    },

    shouldReset: function () {
        "use strict";

        if (!Cheetah.state.resetCheck()) {
            return false;
        }

        if (Cheetah.state.neverclicked) {
            return true;
        }

        if (Cheetah.singularSelection.active) {
            return false;
        }

        if (Cheetah.state.achievements.attainable.any()) {
            return false;
        }

        return (Cheetah.count.cookies.remainingToGainFor.reset() <= 0);
    },

    // true when it is time to click like frenzied
    speedyClick: function () {
        "use strict";

        if (Game.clickFrenzy > 0) {
            return true;
        }

        if (Cheetah.state.underSpeedyClickLimit()) {
            return true;
        }

        return false;
    },

    // true when it is time to click like frenzied because number of cookies is
    // below set limit
    underSpeedyClickLimit: function () {
        "use strict";
        var speedyClickLimit;

        speedyClickLimit = Cheetah.config.bigCookieClickLimit;

        if (Game.cookies < speedyClickLimit) {
            return true;
        }

        return false;
    },

    cycles: {
        grandmapocalypseSelect: new Cheetah.Cycler(5000),
        update: new Cheetah.Cycler(Cheetah.config.intervals.update)
    },
    update: function () {
        "use strict";
        return Cheetah.state.cycles.update.cycle();
    }
};

Cheetah.ui = {
    announce: {
        aim: function () {
            "use strict";
            var hc;
            if (Cheetah.state.goForNeverclick) {
                Cheetah.debug.log("Going for Neverclick.");
            } else {
                hc = Cheetah.count.heavenlyChips.toGainToReset();
                Cheetah.debug.log("Going for " + hc + " heavenly chips.");
            }
        }
    },
    click: {

        // main.js:1523 (Cheetah.constants.compatibleGameVersion)
/*
        bigCookie: function (event) {
            "use strict";
            var cps, dur, pic, size, text, x, xd, y, yd, z;

            if (event) {
                event.preventDefault();
            }
            if (new Date().getTime() - Game.lastClick >= 1000 / 250) {
                if (new Date().getTime() - Game.lastClick < 1000 / 15) {
                    Game.autoclickerDetected += Game.fps;
                    if (Game.autoclickerDetected >= Game.fps * 5) {
                        Game.Win("Uncanny clicker");
                    }
                }
                Game.Earn(Game.computedMouseCps);
                Game.handmadeCookies += Game.computedMouseCps;
                if (Game.prefs.particles) {
                    x = Game.mouseX;
                    y = Game.mouseY;
                    xd = Math.random() * 4 - 2;
                    yd = Math.random() * -2 - 2;
                    size = Math.random() * 0.5 + 0.2;
                    dur = 1;
                    z = 2;
                    Game.particleAdd();
                    Game.particleAdd(x, y, xd, yd, size, dur, z);
                }
                if (Game.prefs.numbers) {
                    cps = Cheetah.beautify.short(Game.computedMouseCps);
                    x = Game.mouseX + Math.random() * 8 - 4;
                    y = Game.mouseY - 8 + Math.random() * 8 - 4;
                    xd = 0;
                    yd = -2;
                    size = 1;
                    dur = 4;
                    z = 2;
                    pic = "";
                    text = cps;
                    Game.particleAdd(x, y, xd, yd, size, dur, z, pic, text);
                }
                Game.cookieClicks += 1;
            }
            Game.lastClick = new Date().getTime();
        }
*/
    },

    import: function (data) {
        "use strict";
        var p = new Cheetah.Importer(
            ["plot"],
            "ui",
            Cheetah.ui
        );
        return p.import(data);
    },

    initialize: function () {
        "use strict";
        if (!Cheetah.state.resetting) {
            Cheetah.ui.announce.aim();
        }
        Cheetah.ui.keys.add();
        Cheetah.ui.substitute.all();
        Cheetah.ui.ping.initialize();
        Cheetah.ui.plot.initialize();
    },

    keys: {
        add: function () {
            "use strict";
            Cheetah.ui.keys.autobuyToggler.add();
            Cheetah.ui.keys.instant.add();
        },
        autobuyToggler: {
            add: function () {
                "use strict";
                var onOff;
                if (Cheetah.ui.keys.autobuyToggler.added) { return; }

                document.addEventListener("keydown", function (event) {
                    var key = 65; // a

                    if (event.ctrlKey || event.shiftKey) { return true; }
                    if (Cheetah.state.bakeryNameActive()) { return true; }
                    if (event.keyCode === key) {
                        Cheetah.state.autoBuy = !Cheetah.state.autoBuy;
                        onOff = (Cheetah.state.autoBuy ? "on" : "off");
                        Game.Notify("Autobuy", "Autobuy is " + onOff);
                    }
                    return false;
                });
                Cheetah.ui.keys.autobuyToggler.added = true;
            },
            added: false
        },

        instant: {
            add: function () {
                "use strict";
                Cheetah.ui.keys.instant.buy.add();
                Cheetah.ui.keys.instant.research.add();
            },
            buy: {
                add: function () {
                    "use strict";
                    if (Cheetah.ui.keys.instant.buy.added) { return; }

                    document.addEventListener("keydown", function (event) {
                        var earn, instantBuy, key;

                        if (Cheetah.state.bakeryNameActive()) { return true; }
                        if (event.ctrlKey) { return true; }

                        earn = true;
                        if (event.shiftKey) { earn = false; }

                        instantBuy = Cheetah.debug.keys.instantBuy;
                        key = 80; // p
                        if (instantBuy && event.keyCode === key) {
                            Cheetah.debug.gainCookiesForInstantBuy(earn);
                        }
                        return false;
                    });
                    Cheetah.ui.keys.instant.buy.added = true;
                },
                added: false
            },
            research: {
                add: function () {
                    "use strict";
                    if (Cheetah.ui.keys.instant.research.added) { return; }
                    document.addEventListener("keydown", function (event) {
                        var instantResearch, key;

                        if (event.ctrlKey || event.shiftKey) { return false; }

                        instantResearch = Cheetah.debug.keys.instantResearch;
                        key = 82; // r
                        if (event.keyCode === key && instantResearch) {
                            Cheetah.debug.finishResearch();
                        }

                        return false;
                    });
                    Cheetah.ui.keys.instant.research.added = true;
                },
                added: false
            }
        }
    },

    ping: {
        initialize: function () {
            "use strict";
            Cheetah.ui.ping.loadSample();
            Cheetah.ui.ping.previousForReset = -1;
        },
        sample: null,
        previousForReset: -1,
        forReset: function (s) {
            "use strict";
            var previousValue, value;

            value = Cheetah.beautify.long(s);
            if (Cheetah.ui.ping.previousForReset < 0) {
                value += " remaining.";
                Cheetah.debug.log("Ping: initial ping when " + value);
                Cheetah.ui.ping.play();
                Cheetah.ui.ping.previousForReset = s;
                return;
            }
            if (s < 0) {
                return;
            }

            previousValue = Cheetah.ui.ping.previousForReset;
            previousValue = Cheetah.beautify.long(previousValue);
            if (s < Cheetah.ui.ping.previousForReset / 2) {
                value += " remaining.";
                Cheetah.debug.log("Ping: when " + value);
                Cheetah.ui.ping.play();
                Cheetah.ui.ping.previousForReset = s;
            } else if (s > Cheetah.ui.ping.previousForReset) {
                value += ".";
                Cheetah.debug.log("Ping: for increased remaining " + value);
                Cheetah.ui.ping.play();
                Cheetah.ui.ping.previousForReset = s;
            }
        },
        loadSample: function () {
            "use strict";
            var src;
            if (Cheetah.ui.ping.sample) {
                return;
            }
            src = "data:audio/ogg;base64," + Cheetah.ui.ping.audioData;
            Cheetah.ui.ping.sample = new Audio(src);
        },
        play: function () {
            "use strict";
            var warning;
            if (!Cheetah.ui.ping.sample) {
                warning = "WARNING: ";
                warning += "tried to play uninitialized sample.";
                Cheetah.debug.log(warning);
                return;
            }
            Cheetah.ui.ping.sample.play();
        }
    },

    plot: {
        addPoint: function (hc, point) {
            "use strict";
            var w;

            if (isNaN(hc)) {
                w = "WARNING: hc is NaN.";
                Cheetah.debug.log(w);
                hc = 0;
            }

            point.push(hc);
        },
        canvas: {
            update: function () {
                "use strict";
                var bottom, c, height, plot;

                plot = Cheetah.ui.plot;
                c = plot.canvas.element;

                if (c.width !== window.innerWidth) {
                    c.width = window.innerWidth;
                }

                height = Math.round(window.innerHeight / 3);
                if (c.height !== height) {
                    c.height = height;
                }

                bottom = height - window.innerHeight;
                bottom += "px";
                c.style.bottom = bottom;

                plot.draw();
            },
            clear: function () {
                "use strict";
                var h, w;

                h = Cheetah.ui.plot.canvas.element.height;
                w = Cheetah.ui.plot.canvas.element.width;
                Cheetah.ui.plot.canvas.context.clearRect(0, 0, w, h);
            },
            context: null,
            element: (function () {
                "use strict";
                var canvas, height, width;

                canvas = document.createElement("canvas");
                height = Math.round(window.innerHeight / 3);
                canvas.setAttribute("height", height);
                width = window.innerWidth;
                canvas.setAttribute("width", width);

                document.body.appendChild(canvas);

                return canvas;
            }()),
            fade: {
                in: function () {
                    "use strict";
                    var c, i, o, plot;

                    plot = Cheetah.ui.plot;
                    c = plot.canvas.element;
                    i = setInterval(function () {
                        o = parseFloat(c.style.opacity);
                        if (o >= 1) {
                            clearInterval(i);
                        }
                        o += 0.1;
                        o = Math.min(1, o);
                        c.style.opacity = o;
                    }, 100);
                },
                out: function () {
                    "use strict";
                    var c, i, o, plot;

                    plot = Cheetah.ui.plot;
                    c = plot.canvas.element;
                    i = setInterval(function () {
                        o = parseFloat(c.style.opacity);
                        if (o <= 0) {
                            clearInterval(i);
                        }
                        o = parseFloat(c.style.opacity);
                        o -= 0.1;
                        o = Math.max(0, o);
                        c.style.opacity = o;
                    }, 100);
                }
            },
            hide: function () {
                "use strict";
                var plot;

                plot = Cheetah.ui.plot;
                plot.canvas.element.style.opacity = "0.0";
            },
            initialize: function () {
                "use strict";
                var c, plot;

                plot = Cheetah.ui.plot;
                c = plot.canvas;
                c.style();
                c.hide();

                c.context = c.element.getContext("2d");
                c.update();
            },
            show: function () {
                "use strict";
                var plot;

                plot = Cheetah.ui.plot;
                plot.canvas.element.style.opacity = "1.0";
            },
            style: function () {
                "use strict";
                var c, plot, style;

                plot = Cheetah.ui.plot;
                c = plot.canvas.element;
                style = plot.constants.style.css;
                c.setAttribute("style", style);
            }
        },
        constants: {
            pointsMax: 60, // full graph t in minutes
            style: {
                // just below golden cookies (@ 10000000000)
                css: "background-color: rgba(170, 170, 170, 0.18);"
                    + "left:0;pointer-events:none;"
                    + "position:relative;z-index:9999999999;",
                font: {
                    color: "#eeee44",
                    face: "20px Kavoon", // Game.LeftBackground.font
                    size: 20,
                    shadow: "#333"
                },
                gained: {
                    point: {
                        color: {
                            big: "#00ff00",
                            small: "#ffff00"
                        },
                        size: {
                            big: 5,
                            small: 3
                        }
                    },
                    stroke: {
                        color: "#eeee44"
                    }
                },
                hcp: {
                    color: "#00ff00"
                },
                scrollBar: {
                    width: 20
                },
                total: {
                    overAim: {
                        point: {
                            color: {
                                small: "#88ff88"
                            },
                            size: {
                                small: 3
                            }
                        },
                        stroke: {
                            color: "#6e6"
                        }
                    },
                    underAim: {
                        point: {
                            color: {
                                small: "#ffffff"
                            },
                            size: {
                                small: 3
                            }
                        },
                        stroke: {
                            color: "#eee"
                        }
                    }
                }
            }
        },
        draw: function () {
            "use strict";
            var plot;

            plot = Cheetah.ui.plot;

            if (plot.total.point.size() < 1) {
                return;
            }

            if (plot.total.point.size() === 1) {
                if (plot.total.point.get(0) === 0) {
                    return;
                }
            }

            plot.canvas.clear();
            plot.gained.draw();
            plot.total.draw();
            plot.hcp.draw();
            plot.canvas.fade.in();
        },
        gained: {
            addPoint: function (hc) {
                "use strict";
                var plot, point;

                plot = Cheetah.ui.plot;

                point = plot.gained.point;
                if (point.size() === 0 && hc > 0) {
                    plot.canvas.fade.in();
                }

                if (point.size() === 1) {
                    if (hc === 0 && point.get(0) === 0) {
                        return;
                    }
                    plot.canvas.fade.in();
                }
                if (point.size() > 1) {
                    plot.canvas.fade.in();
                }

                plot.addPoint(hc, point);

                hc = Cheetah.count.heavenlyChips.gained();
                point = plot.total.point;
                plot.addPoint(hc, point);
            },
            draw: function () {
                "use strict";
                var full, half, i, p, peak, peaked, plot, pos, pp, style;

                plot = Cheetah.ui.plot;
                style = plot.constants.style.gained;

                peak = plot.gained.point.max();
                peaked = false;
                pp = false;
                full = plot.gained.point.size();
                for (i = 0; i < full; i += 1) {
                    p = plot.gained.point.get(i);
                    pos = plot.pointPosition(i, p, peak);
                    plot.stroke(pp, pos.x, pos.y, style);
                    pp = { x: pos.x, y: pos.y };

                    if (!peaked && p === peak) {
                        plot.point.big(pos.x, pos.y, style);
                        half = (i > 30);
                        plot.gained.peak.draw(pos.x, pos.y, p, half);
                        peaked = true;
                    } else {
                        plot.point.small(pos.x, pos.y, style);
                    }
                }
            },
            import: function (data) {
                "use strict";
                var p = new Cheetah.Importer(
                    ["point"],
                    "gained",
                    Cheetah.ui.plot.gained
                );
                return p.import(data);
            },
            initialize: function () {
                "use strict";
                var plot, size;

                plot = Cheetah.ui.plot;
                size = plot.constants.pointsMax;

                plot.gained.point = new Cheetah.Queue(size);
            },
            peak: {
                draw: function (x, y, value, halfway) {
                    "use strict";
                    var plot, pointWidth;

                    plot = Cheetah.ui.plot;
                    if (value === 0) {
                        return;
                    }

                    value = "peak: " + Cheetah.prettyText.fixed.hc(value);

                    pointWidth = plot.constants.style.gained.point.size.big;
                    x += Math.round(1.5 * pointWidth);
                    if (halfway) {
                        x -= 100;
                    }
                    y += Math.round(1.5 * pointWidth) + 20;
                    plot.shadowText(value, x, y);
                }
            },
            point: null
        },
        hcp: {
            clear: function () {
                "use strict";
                var ctx, fontSize, h, m, scrollbarWidth, style, w, x, y;

                ctx = Cheetah.ui.plot.canvas.context;

                style = Cheetah.ui.plot.constants.style;
                fontSize = style.font.size;
                scrollbarWidth = style.scrollBar.width;

                h = Cheetah.ui.plot.canvas.element.height;
                w = Cheetah.ui.plot.canvas.element.width;

                m = ctx.measureText(Cheetah.ui.plot.hcp.previous.text);
                m.height = fontSize;

                x = w - (m.width + scrollbarWidth + 1); // 1 px shadow
                y = Cheetah.ui.plot.hcp.previous.y - fontSize;

                w = m.width + 2; // shadow (1 px) on both sides
                h = Math.round(1.33 * m.height);
                ctx.clearRect(x, y, w, h);
            },
            draw: function () {
                "use strict";
                var hcpText, plot, position;

                plot = Cheetah.ui.plot;

                Cheetah.ui.plot.hcp.clear();

                hcpText = Cheetah.ui.plot.hcp.text();
                if (hcpText === "") {
                    Cheetah.ui.plot.hcp.previous.text = "";
                    return;
                }

                position = Cheetah.ui.plot.hcp.position(hcpText);
                plot.shadowText(hcpText, position.x, position.y);
                Cheetah.ui.plot.hcp.previous.text = hcpText;
                Cheetah.ui.plot.hcp.previous.y = position.y;
            },
            import: function (data) {
                "use strict";
                var p = new Cheetah.Importer(
                    ["previous"],
                    "hcp",
                    Cheetah.ui.plot.hcp
                );
                return p.import(data);
            },
            position: function (text) {
                "use strict";
                var fontSize, h, m, scrollbarWidth, style, w, x, y;

                Cheetah.ui.plot.hcp.clear();

                style = Cheetah.ui.plot.constants.style;
                fontSize = style.font.size;
                scrollbarWidth = style.scrollBar.width;

                h = Cheetah.ui.plot.canvas.element.height;
                w = Cheetah.ui.plot.canvas.element.width;

                m = Cheetah.ui.plot.canvas.context.measureText(text);
                m.height = fontSize;

                x = w - (m.width + scrollbarWidth);
                y = h - fontSize;

                x = w - (m.width + scrollbarWidth);
                y = h - fontSize;

                return { x: x, y: y };
            },
            previous: {
                import: function (data) {
                    "use strict";
                    var p = new Cheetah.Importer(
                        ["text", "y"],
                        "previous",
                        Cheetah.ui.plot.hcp.previous
                    );
                    return p.import(data);
                },
                text: "",
                y: 0
            },
            text: function () {
                "use strict";
                var hcph, hcpm, p;

                p = Cheetah.count.heavenlyChips.per;

                hcpm = p.minute.data.hcpm;
                hcph = p.hour.data.hcph;
                if (Math.round(hcpm) === 0 && hcph === 0) {
                    return "";
                }

                hcpm = Cheetah.prettyText.fixed.hc(hcpm);
                hcph = Cheetah.prettyText.fixed.hc(hcph);

                return hcpm + "/" + hcph + " hcpm/h";
            }
        },

        import: function (data) {
            "use strict";
            var p = new Cheetah.Importer(
                ["gained", "hcp", "lastUpdate", "total"],
                "plot",
                Cheetah.ui.plot
            );
            if (!p.import(data)) {
                return false;
            }
            Cheetah.ui.plot.draw();
            return true;
        },
        initialize: function () {
            "use strict";
            var plot;

            plot = Cheetah.ui.plot;
            plot.gained.initialize();
            plot.total.initialize();
            plot.canvas.initialize();
            plot.lastUpdate.initialize();
            document.body.onresize = plot.canvas.update;
        },
        lastUpdate: {
            hour: -1,
            import: function (data) {
                "use strict";
                var p = new Cheetah.Importer(
                    ["hour", "minute"],
                    "lastUpdate",
                    Cheetah.ui.plot.lastUpdate
                );
                return p.import(data);
            },
            initialize: function () {
                "use strict";
                Cheetah.ui.plot.lastUpdate.hour = -1;
                Cheetah.ui.plot.lastUpdate.minute = -1;
            },
            minute: -1
        },
        point: {
            big: function (x, y, style) {
                "use strict";
                var ctx, size, xd, yd;

                ctx = Cheetah.ui.plot.canvas.context;
                size = style.point.size.big;
                xd = Math.floor(size / 2);
                yd = Math.floor(size / 2);
                ctx.fillStyle = style.point.color.big;
                ctx.fillRect(x - xd, y - yd, size, size);
                Cheetah.ui.plot.point.small(x, y, style);
            },
            small: function (x, y, style) {
                "use strict";
                var ctx, size, xd, yd;

                ctx = Cheetah.ui.plot.canvas.context;
                size = style.point.size.small;
                xd = Math.floor(size / 2);
                yd = Math.floor(size / 2);
                ctx.fillStyle = style.point.color.small;
                ctx.fillRect(x - xd, y - yd, size, size);
            }
        },
        pointPosition: function (x, y, peak) {
            "use strict";
            var full, h, w;

            if (isNaN(y)) {
                y = 0;
            }
            h = Cheetah.ui.plot.canvas.element.height;
            y = h - Math.round(h * y / peak);

            w = Cheetah.ui.plot.canvas.element.width;
            full = Cheetah.ui.plot.constants.pointsMax;
            x *= Math.max(1, w / full);

            return { x: x, y: y };
        },
        shadowText: function (text, x, y) {
            "use strict";
            var ctx, plot, style, xd, yd;

            plot = Cheetah.ui.plot;
            ctx = plot.canvas.context;
            style = ctx.fillStyle;
            ctx.font = plot.constants.style.font.face;

            ctx.fillStyle = plot.constants.style.font.shadow;
            for (xd = -1; xd < 2; xd += 1) {
                for (yd = -1; yd < 2; yd += 1) {
                    ctx.fillText(text, x + xd, y + yd);
                }
            }

            ctx.fillStyle = plot.constants.style.font.color;
            ctx.fillText(text, x, y);

            ctx.fillStyle = style;
        },
        stroke: function (pp, x, y, style) {
            "use strict";
            var ctx;

            if (!pp) {
                return;
            }

            ctx = Cheetah.ui.plot.canvas.context;

            ctx.strokeStyle = style.stroke.color;
            ctx.beginPath();
            ctx.moveTo(pp.x, pp.y);
            ctx.lineTo(x, y);
            ctx.stroke();
        },
        total: {
            addPoint: function (hc) {
                "use strict";
                var plot, point;
                plot = Cheetah.ui.plot;
                point = plot.total.point;
                return plot.addPoint(hc, point);
            },
            draw: function () {
                "use strict";
                var aim, full, i, p, peak, plot, pos, pp, style, styles;

                plot = Cheetah.ui.plot;
                styles = plot.constants.style.total;

                aim = Cheetah.count.heavenlyChips.toGainToReset();
                peak = Math.max(aim, plot.total.point.max());
                pp = false;
                full = plot.total.point.size();
                for (i = 0; i < full; i += 1) {
                    p = plot.total.point.get(i);
                    pos = plot.pointPosition(i, p, peak);
                    style = styles.underAim;
                    if (p >= aim) {
                        style = styles.overAim;
                    }
                    plot.stroke(pp, pos.x, pos.y, style);
                    pp = { x: pos.x, y: pos.y };
                    plot.point.small(pos.x, pos.y, style);
                }
            },
            import: function (data) {
                "use strict";
                var p = new Cheetah.Importer(
                    ["point"],
                    "total",
                    Cheetah.ui.plot.total
                );
                return p.import(data);
            },
            initialize: function () {
                "use strict";
                var plot, size;

                plot = Cheetah.ui.plot;
                size = plot.constants.pointsMax;

                plot.total.point = new Cheetah.Queue(size);
            },
            point: null
        },
        update: function () {
            "use strict";
            var b, hc, p, plot;

            p = Cheetah.count.heavenlyChips.per.hour;
            plot = Cheetah.ui.plot;

            b = p.data.buffer.time;
            if (b.last !== plot.lastUpdate.hour) {
                plot.lastUpdate.hour = b.last;
                b = p.data.buffer.hc;
                hc = b.gained.getLast();
                plot.gained.addPoint(hc);
                plot.draw();
            } else {
                p = Cheetah.count.heavenlyChips.per.minute;
                b = p.data.buffer.time;
                if (b.last !== plot.lastUpdate.minute) {
                    plot.lastUpdate.minute = b.last;
                    plot.hcp.draw();
                }
            }
        }
    },

    popup: {
        note: function (title, desc, pic, quick) {
            "use strict";
            var n;

            title = title.replace(/ : /g, ": ");
            desc = desc.replace(/ : /g, ": ");
            quick = 1;

            n = Cheetah.constants.functions.game.notify;
            return n(title, desc, pic, quick);
        },

        text: function (text) {
            "use strict";
            text = text.replace(/ : /g, ": ");
            return Cheetah.constants.functions.game.popup(text);
        }
    },

    reset: function (manuallyTriggered, hard) {
        "use strict";
        var clear, hcGained, resetText;

        Cheetah.state.resetting = true;
        Cheetah.state.neverclicked = false;

        // hold off reset until hijacked buy functions returned. automatic reset
        // should not happen asynchronously, but there are still manual resets
        // to worry about, so this check is not redundant.
        if (Cheetah.state.hijackedFunctions) {
            setTimeout(function () {
                Cheetah.ui.reset(manuallyTriggered);
            }, 100);
            return;
        }

        if (hard) {
            resetText = "Hard reset.";
        } else {
            if (manuallyTriggered) {
                resetText = "Manual reset: ";
            } else {
                resetText = "Automatic reset: ";
            }
            Cheetah.sellOut();
            Cheetah.win.achievements.for.reset();
            hcGained = Cheetah.count.heavenlyChips.gained();
            Cheetah.state.lastHeavenlyChipsGained = hcGained;
            if (hcGained) {
                resetText += hcGained + " heavenly chips gained.";
            } else {
                resetText += "No heavenly chips gained!";
            }
        }
        Cheetah.constants.functions.game.reset(true, hard);
        if (hard) {
            clear = true;
            Cheetah.save(clear);

            // main.js:1451 (Cheetah.constants.compatibleGameVersion)
            Game.cookiesReset = 0;
            Game.prestige = [];
            Game.CalculatePrestige();
        }
        Cheetah.initialize();

        setTimeout(function () {
            Cheetah.ui.announce.aim();
            Cheetah.state.resetting = false;
        }, 5000); // hold off automatics until properly reset

        Cheetah.debug.log(resetText);
    },
    resetButtonHandler: function (bypass, hard) {
        "use strict";
        var manuallyTriggered = true;
        Cheetah.ui.reset(manuallyTriggered, hard, bypass);
    },

    substitute: {
        all: function () {
            "use strict";
            if (Game.version === Cheetah.constants.compatibleGameVersion) {
                Cheetah.ui.substitute.click.all();
                Cheetah.ui.substitute.popup.all();
                Cheetah.ui.substitute.reset();
            }
        },
        click: {
            all: function () {
                "use strict";
/*
                Cheetah.ui.substitute.click.bigCookie();
*/
                Cheetah.ui.substitute.click.oneMind();
            },
/*
            bigCookie: function () {
                "use strict";
                Game.ClickCookie = Cheetah.ui.click.bigCookie;
            },
*/
            oneMind: function () {
                "use strict";

                // confirmations are useless, period.
                Game.Upgrades["One mind"].clickFunction = function () {
                    return true;
                };
            }
        },
        popup: {
            all: function () {
                "use strict";
                Cheetah.ui.substitute.popup.note();
                Cheetah.ui.substitute.popup.text();
            },
            note: function () {
                "use strict";
                Game.Notify = Cheetah.ui.popup.note;
            },
            text: function () {
                "use strict";
                Game.Popup = Cheetah.ui.popup.text;
            }
        },
        reset: function () {
            "use strict";
            Game.Reset = Cheetah.ui.resetButtonHandler;
        }
    },
    ticker: {
        timeBuffer: {
            cycled: 0,
            tick: function () {
                "use strict";
                var fullCycle, iTickerTime, iUpdate;

                iTickerTime = Cheetah.config.intervals.tickerTime;
                iUpdate = Cheetah.config.intervals.update;
                fullCycle = iTickerTime / iUpdate;

                Cheetah.ui.ticker.timeBuffer.cycled += 1;
                if (Cheetah.ui.ticker.timeBuffer.cycled > fullCycle - 1) {
                    Cheetah.ui.ticker.timeBuffer.cycled = 0;
                }
            },
            update: function () {
                "use strict";
                var autoResetText, cibText, frenzyText, timeBetween,
                    timeText, timeTill;

                if (!Cheetah.ui.ticker.timeBuffer.cycled) {
                    timeTill = Cheetah.prettyText.cookies.till;
                    if (Cheetah.config.autoReset) {
                        autoResetText = timeTill.autoReset();
                    } else {
                        autoResetText = "";
                    }

                    timeTill = Cheetah.prettyText.time.till;
                    timeText = timeTill.purchase();
                    frenzyText = Cheetah.prettyText.frenzy();

                    if (Cheetah.state.bankingCookies()) {
                        cibText = timeTill.cookiesInBankText();
                        if (cibText !== "0") {
                            timeBetween = Cheetah.prettyText.time.between;
                            timeText = timeBetween.cibAndPurchase();
                            if (timeText === "0") {
                                timeText = "";
                            } else {
                                timeText = "in " + timeText + " more";
                            }
                        }
                    } else {
                        cibText = "0";
                    }

                    Cheetah.ui.ticker.timeBuffer.autoResetText = autoResetText;
                    Cheetah.ui.ticker.timeBuffer.timeText = timeText;
                    Cheetah.ui.ticker.timeBuffer.frenzyText = frenzyText;
                    Cheetah.ui.ticker.timeBuffer.cibText = cibText;
                }
                Cheetah.ui.ticker.timeBuffer.tick();
            },
            autoResetText: "",
            cibText: "",
            frenzyText: "",
            timeText: ""
        },

        update: function () {
            "use strict";
            var autoResetText, cibText, frenzyText, itemName, purchaseText, s,
                timeText;

            if (Cheetah.state.resetting) {
                Game.Ticker = "Initializing Cheetah...";
                Game.TickerAge = Cheetah.config.intervals.update;
                return;
            }

            if (!Cheetah.state.selection.done) {
                Game.Ticker = "Selection unfinished";
                Game.TickerAge = Cheetah.config.intervals.update;
                return;
            }

            s = Cheetah.state.selection.selectedItem;
            itemName = s.name;
            if (Cheetah.state.selection.selectedItem.amount > 1) {
                itemName = "a batch of " + s.amount + " " + s.gameObject.plural;
            } else {
                if (s.gameObject.articledName) {
                    itemName = s.gameObject.articledName;
                } else {
                    itemName = s.gameObject.name;
                }
            }

            if (Cheetah.state.selection.selectedItem.upgrade) {
                itemName += " + ";
                itemName += Cheetah.state.selection.selectedItem.upgrade.name;
            }
            purchaseText = Cheetah.prettyText.purchase();

            // timers are updated only once / second
            Cheetah.ui.ticker.timeBuffer.update();
            autoResetText = Cheetah.ui.ticker.timeBuffer.autoResetText;
            timeText = Cheetah.ui.ticker.timeBuffer.timeText;
            frenzyText = Cheetah.ui.ticker.timeBuffer.frenzyText;
            cibText = Cheetah.ui.ticker.timeBuffer.cibText;
            if (cibText !== "0" && Cheetah.state.bankingCookies()) {
                Game.Ticker = "Banking cookies for " + cibText
                    + "<br>before buying " + itemName
                    + "<br>" + timeText
                    + "<br>" + frenzyText
                    + "<br>" + autoResetText;
            } else {
                Game.Ticker = "Buying " + itemName
                    + "<br>" + purchaseText
                    + "<br>" + timeText
                    + "<br>" + frenzyText
                    + "<br>" + autoResetText;
            }

            Game.TickerAge = Cheetah.config.intervals.update;
        }
    },

    update: function () {
        "use strict";
        Cheetah.ui.plot.update();
        Cheetah.ui.ticker.update();
    }
};

Cheetah.Queue = function (length) {
    "use strict";
    this.buffer = [];
    this.length = length;
};
Cheetah.Queue.prototype.get = function (key) {
    "use strict";
    return this.buffer[key];
};
Cheetah.Queue.prototype.max = function () {
    "use strict";
    return Math.max.apply(Math, this.buffer);
};
Cheetah.Queue.prototype.import = function (data) {
    "use strict";
    var w;

    try {
        if (data.length === undefined) {
            w = "ERROR: Queue length not in data.";
            Cheetah.debug.log(w);
            return false;
        }
        if (isNaN(data.length)) {
            w = "ERROR: Queue length (" + !data.length + ") is not a number ";
            w += "but a " + typeof data.length;
            Cheetah.debug.log(w);
            return false;
        }
        if (data.length < 0) {
            w = "ERROR: Queue length (" + data.length + ") is negative.";
            Cheetah.debug.log(w);
            return false;
        }

        this.length = data.length;

        if (data.buffer === undefined) {
            w = "ERROR: Queue buffer not in data.";
            Cheetah.debug.log(w);
            return false;
        }

        if (!Array.isArray(data.buffer)) {
            w = "ERROR: Queue buffer (" + data.buffer + ") ";
            w += "is not an array but a " + typeof data.buffer + ".";
            Cheetah.debug.log(w);
            return false;
        }

        this.buffer = data.buffer;

        return true;
    } catch (e) {
        w = "ERROR: failed to import Queue. ";
        w += "The error message was: " + e;
        Cheetah.debug.log(w);
        return false;
    }
};
Cheetah.Queue.prototype.push = function (item) {
    "use strict";
    this.buffer.push(item);
    if (this.buffer.length > this.length) { this.buffer.shift(); }
};
Cheetah.Queue.prototype.size = function () {
    "use strict";
    return this.buffer.length;
};

Cheetah.save = function (clear) {
    "use strict";
    var data, save;

    if (clear) {
        window.localStorage.removeItem(Cheetah.constants.saveName);
        Cheetah.debug.log("Cleared saved Cheetah data.");
        return;
    }

    data = {
        version: Cheetah.version,
        count: Cheetah.count,
        ui: Cheetah.ui
    };

    save = Cheetah.constants.saveName;
    window.localStorage.setItem(save, JSON.stringify(
        data,
        function (key, value) {
            if (key === "import") {
                return;
            }
            if (key === "ping") {
                return;
            }
            if (key === "canvas") {
                return;
            }
            return value;
        }
    ));
};

Cheetah.test = {
    constants: function () {
        "use strict";
        var i, j, obups, up, ups, w;

        obups = Cheetah.constants.objectUpgrades;
        if (obups.length !== Game.ObjectsN) {
            w = "WARNING: objectUpgrades prepared for a wrong amount of ";
            w += "objects (" + obups.length + " vs. actual amount ";
            w += Game.ObjectsN + ").\n";
            w += "The rest of these tests is bound to fail.";
            Cheetah.debug.log(w);
        }

        ups = Cheetah.constants.upgrades;
        for (i = 0; i < obups.length; i += 1) {
            for (up in obups[i]) {
                if (obups[i].hasOwnProperty(up)) {
                    if (!ups.hasOwnProperty(up)) {
                        w = "WARNING: upgrades does not have \"" + up + "\", ";
                        w += "but objectUpgrades[" + i + "] does.";
                        Cheetah.debug.log(w);
                    }

                    if (obups[i][up] instanceof Array) {
                        if (obups[i][up].length !== 2) {
                            w = "WARNING: unexpected objectUpgrades[" + i + "]";
                            w += " array length " + obups[i][up].length + ".";
                            Cheetah.debug.log(w);
                        }

                        if (obups[i][up][0] > Game.ObjectsById.length) {
                            w = "WARNING: objectUpgrades[" + i + "] has an ";
                            w = "out of bounds object index [0].";
                            Cheetah.debug.log(w);
                        }

                        for (j = 0; j < 2; j += 1) {
                            if (isNaN(obups[i][up][j])) {
                                w = "WARNING: objectUpgrades[" + i + "] has a ";
                                w += "NaN at [" + j + "].";
                                Cheetah.debug.log(w);
                            }
                            if (obups[i][up][j] < 1) {
                                w = "WARNING: objectUpgrades[" + i + "] has a ";
                                w += "value less than 1 at [" + j + "].";
                                Cheetah.debug.log(w);
                            }
                        }
                    }
                }
            }
        }
    }
};

Cheetah.update = function () {
    "use strict";

    if (!Cheetah.state.update()) {
        return;
    }

    if (Cheetah.state.resetting) {
        Cheetah.count.update();
        Cheetah.ui.update();
        return;
    }

    if (Cheetah.state.shouldReset()) {
        Cheetah.ui.reset();
        return;
    }

    Cheetah.win.achievements.easy();

    if (Cheetah.state.select()) {
        Cheetah.select.optimalItem();

    // if previous selection is still valid, and its price is reached,
    // buy it and select new.
    } else if (Cheetah.state.buy()) {
        Cheetah.state.selection.selectedItem.buy();
        Cheetah.select.optimalItem();

    // forcibly update selection once a second during Grandmapocalypse
    } else if (Cheetah.state.grandmapocalypseSelect()) {
        Cheetah.select.optimalItem();
    }

    Cheetah.count.update();
    Cheetah.ui.update();
};

Cheetah.version = {
    string: "1.0465.1.9",
    import: function (data) {
        "use strict";
        var w;
        if (data.string !== Cheetah.version.string) {
            w = "WARNING: attempting to load data from a different version ";
            w += "(" + data.string + ") ";
            w += "of Cheetah than what's running ";
            w += "(" + Cheetah.version.string + ").";
            Cheetah.debug.log(w);
        }

        return true;
    }
};

Cheetah.win = {
    easy: {
        achievement: [
            function () {
                "use strict";
                if (Game.Achievements["Cheated cookies taste awful"].won) {
                    return true;
                }

                Game.Win("Cheated cookies taste awful");
                return true;
            },
            function () {
                "use strict";
                if (Game.Achievements["Cookie-dunker"].won) {
                    return true;
                }

                // well I am not a cheater
                if (Game.milkProgress <= 0.1) {
                    return false;
                }

                Game.Win("Cookie-dunker");
                return true;
            },
            function () {
                "use strict";

                if (Game.Achievements["God complex"].won) {
                    return true;
                }

                // changing the name and letting the game give the achievement
                // would require Logic() to run so fuck it.
                // main.js:6096 (Cheetah.constants.compatibleGameVersion)
                Game.Win("God complex");
                return true;
            },
            function () {
                "use strict";

                if (Game.Achievements["What's in a name"].won) {
                    return true;
                }

                // trivial manual interaction.
                // main.js:813 (Cheetah.constants.compatibleGameVersion)
                Game.Win("What's in a name");
                return true;
            },
            function () {
                "use strict";
                var grandma = 1;

                if (Game.Achievements["Just wrong"].won) {
                    return true;
                }

                if (!Game.ObjectsById[grandma].amount) {
                    return false;
                }

                Game.ObjectsById[grandma].sell();
                Cheetah.state.selection.done = false;
                return true;
            },
            function () {
                "use strict";
                if (Game.Achievements["Third-party"].won) {
                    return true;
                }

                Game.Win("Third-party");
                return true;
            },
            function () {
                "use strict";
                if (Game.Achievements["Tiny cookie"].won) {
                    return true;
                }

                Game.ClickTinyCookie();
                return true;
            }
        ]
    },
    achievements: {
        easy: function () {
            "use strict";
            var allWon, i, win;
            allWon = true;
            if (Cheetah.state.achievements.won.easy) {
                return;
            }
            win = Cheetah.win.easy.achievement;
            for (i = 0; i < win.length; i += 1) {
                if (!win[i]()) {
                    allWon = false;
                }
            }

            Cheetah.state.achievements.won.easy = allWon;
        },
        for: {
            reset: function () {
                "use strict";
                if (Game.cookiesEarned >= 1e6) { Game.Win("Sacrifice"); }
                if (Game.cookiesEarned >= 1e9) { Game.Win("Oblivion"); }
                if (Game.cookiesEarned >= 1e12) { Game.Win("From scratch"); }
                if (Game.cookiesEarned >= 1e15) { Game.Win("Nihilism"); }
                if (Game.cookiesEarned >= 1e18) { Game.Win("Dematerialize"); }
                if (Game.cookiesEarned >= 1e21) { Game.Win("Nil zero zilch"); }
                if (Game.cookiesEarned >= 1e24) { Game.Win("Transcendence"); }
                if (Game.cookiesEarned >= 1e27) { Game.Win("Obliterate"); }
                if (Game.cookiesEarned >= 1e30) { Game.Win("Negative void"); }
            }
        }
    }
};

Cheetah.ui.ping.audioData = "T2dnUwACAAAAAAAAAADEkEcwAAAAAKw5LpMBHgF2b3JiaXMAAAAAARErAAAAAAAASHEAAAAAAACZ"
    + "AU9nZ1MAAAAAAAAAAAAAxJBHMAEAAAA33UT1C1L///////////+1A3ZvcmJpcy0AAABYaXBoLk9y"
    + "ZyBsaWJWb3JiaXMgSSAyMDEwMTEwMSAoU2NoYXVmZW51Z2dldCkBAAAAEQAAAFRJVExFPVNvbmFy"
    + "IFBpbmdzAQV2b3JiaXMSQkNWAQAAAQAMUhQhJRlTSmMIlVJSKQUdY1BbRx1j1DlGIWQQU4hJGaV7"
    + "TyqVWErIEVJYKUUdU0xTSZVSlilFHWMUU0ghU9YxZaFzFEuGSQklbE2udBZL6JljljFGHWPOWkqd"
    + "Y9YxRR1jUlJJoXMYOmYlZBQ6RsXoYnwwOpWiQii+x95S6S2FiluKvdcaU+sthBhLacEIYXPttdXc"
    + "SmrFGGOMMcbF4lMogtCQVQAAAQAAQAQBQkNWAQAKAADCUAxFUYDQkFUAQAYAgAAURXEUx3EcR5Ik"
    + "ywJCQ1YBAEAAAAIAACiO4SiSI0mSZFmWZVmWpnmWqLmqL/uuLuuu7eq6DoSGrAQAyAAAGIYhh95J"
    + "zJBTkEkmKVXMOQih9Q455RRk0lLGmGKMUc6QUwwxBTGG0CmFENROOaUMIghDSJ1kziBLPejgYuc4"
    + "EBqyIgCIAgAAjEGMIcaQcwxKBiFyjknIIETOOSmdlExKKK20lkkJLZXWIueclE5KJqW0FlLLpJTW"
    + "QisFAAAEOAAABFgIhYasCACiAAAQg5BSSCnElGJOMYeUUo4px5BSzDnFmHKMMeggVMwxyByESCnF"
    + "GHNOOeYgZAwq5hyEDDIBAAABDgAAARZCoSErAoA4AQCDJGmapWmiaGmaKHqmqKqiKKqq5Xmm6Zmm"
    + "qnqiqaqmqrquqaqubHmeaXqmqKqeKaqqqaqua6qq64qqasumq9q26aq27MqybruyrNueqsq2qbqy"
    + "bqqubbuybOuuLNu65Hmq6pmm63qm6bqq69qy6rqy7Zmm64qqK9um68qy68q2rcqyrmum6bqiq9qu"
    + "qbqy7cqubbuyrPum6+q26sq6rsqy7tu2rvuyrQu76Lq2rsqurquyrOuyLeu2bNtCyfNU1TNN1/VM"
    + "03VV17Vt1XVtWzNN1zVdV5ZF1XVl1ZV1XXVlW/dM03VNV5Vl01VlWZVl3XZlV5dF17VtVZZ9XXVl"
    + "X5dt3fdlWdd903V1W5Vl21dlWfdlXfeFWbd93VNVWzddV9dN19V9W9d9YbZt3xddV9dV2daFVZZ1"
    + "39Z9ZZh1nTC6rq6rtuzrqizrvq7rxjDrujCsum38rq0Lw6vrxrHrvq7cvo9q277w6rYxvLpuHLuw"
    + "G7/t+8axqaptm66r66Yr67ps675v67pxjK6r66os+7rqyr5v67rw674vDKPr6roqy7qw2rKvy7ou"
    + "DLuuG8Nq28Lu2rpwzLIuDLfvK8evC0PVtoXh1XWjq9vGbwvD0jd2vgAAgAEHAIAAE8pAoSErAoA4"
    + "AQAGIQgVYxAqxiCEEFIKIaRUMQYhYw5KxhyUEEpJIZTSKsYgZI5JyByTEEpoqZTQSiilpVBKS6GU"
    + "1lJqLabUWgyhtBRKaa2U0lpqKbbUUmwVYxAy56RkjkkopbRWSmkpc0xKxqCkDkIqpaTSSkmtZc5J"
    + "yaCj0jlIqaTSUkmptVBKa6GU1kpKsaXSSm2txRpKaS2k0lpJqbXUUm2ttVojxiBkjEHJnJNSSkmp"
    + "lNJa5pyUDjoqmYOSSimplZJSrJiT0kEoJYOMSkmltZJKK6GU1kpKsYVSWmut1ZhSSzWUklpJqcVQ"
    + "SmuttRpTKzWFUFILpbQWSmmttVZrai22UEJroaQWSyoxtRZjba3FGEppraQSWympxRZbja21WFNL"
    + "NZaSYmyt1dhKLTnWWmtKLdbSUoyttZhbTLnFWGsNJbQWSmmtlNJaSq3F1lqtoZTWSiqxlZJabK3V"
    + "2FqMNZTSYikptZBKbK21WFtsNaaWYmyx1VhSizHGWHNLtdWUWouttVhLKzXGGGtuNeVSAADAgAMA"
    + "QIAJZaDQkJUAQBQAAGAMY4xBaBRyzDkpjVLOOSclcw5CCCllzkEIIaXOOQiltNQ5B6GUlEIpKaUU"
    + "WyglpdZaLAAAoMABACDABk2JxQEKDVkJAEQBACDGKMUYhMYgpRiD0BijFGMQKqUYcw5CpRRjzkHI"
    + "GHPOQSkZY85BJyWEEEIppYQQQiillAIAAAocAAACbNCUWByg0JAVAUAUAABgDGIMMYYgdFI6KRGE"
    + "TEonpZESWgspZZZKiiXGzFqJrcTYSAmthdYyayXG0mJGrcRYYioAAOzAAQDswEIoNGQlAJAHAEAY"
    + "oxRjzjlnEGLMOQghNAgx5hyEECrGnHMOQggVY845ByGEzjnnIIQQQueccxBCCKGDEEIIpZTSQQgh"
    + "hFJK6SCEEEIppXQQQgihlFIKAAAqcAAACLBRZHOCkaBCQ1YCAHkAAIAxSjknJaVGKcYgpBRboxRj"
    + "EFJqrWIMQkqtxVgxBiGl1mLsIKTUWoy1dhBSai3GWkNKrcVYa84hpdZirDXX1FqMtebce2otxlpz"
    + "zrkAANwFBwCwAxtFNicYCSo0ZCUAkAcAQCCkFGOMOYeUYowx55xDSjHGmHPOKcYYc8455xRjjDnn"
    + "nHOMMeecc845xphzzjnnnHPOOeegg5A555xz0EHonHPOOQghdM455xyEEAoAACpwAAAIsFFkc4KR"
    + "oEJDVgIA4QAAgDGUUkoppZRSSqijlFJKKaWUUgIhpZRSSimllFJKKaWUUkoppZRSSimllFJKKaWU"
    + "UkoppZRSSimllFJKKaWUUkoppZRSSimllFJKKaWUUkoppZRSSimllFJKKaWUUkoppZRSSimllFJK"
    + "KaWUUkoppZRSSimllFJKKaWUUkoplVJKKaWUUkoppZRSSimlACDfCgcA/wcbZ1hJOiscDS40ZCUA"
    + "EA4AABjDGISMOSclpYYxCKV0TkpJJTWMQSilcxJSSimD0FpqpaTSUkoZhJRiCyGVlFoKpbRWaymp"
    + "tZRSKCnFGktKqaXWMuckpJJaS622mDkHpaTWWmqtxRBCSrG11lJrsXVSUkmttdZabS2klFprLcbW"
    + "YmwlpZZaa6nF1lpMqbUWW0stxtZiS63F2GKLMcYaCwDgbnAAgEiwcYaVpLPC0eBCQ1YCACEBAAQy"
    + "SjnnnIMQQgghUoox56CDEEIIIURKMeacgxBCCCGEjDHnIIQQQgihlJAx5hyEEEIIIYRSOucghFBK"
    + "CaWUUkrnHIQQQgillFJKCSGEEEIopZRSSikhhBBKKaWUUkopJYQQQiillFJKKaWEEEIopZRSSiml"
    + "lBBCKKWUUkoppZQSQgihlFJKKaWUUkIIpZRSSimllFJKKCGEUkoppZRSSgkllFJKKaWUUkopIZRS"
    + "SimllFJKKaUAAIADBwCAACPoJKPKImw04cIDEAAAAAIAAkwAgQGCglEIAoQRCAAAAAAACAD4AABI"
    + "CoCIiGjmDA4QEhQWGBocHiAiJAAAAAAAAAAAAAAAAARPZ2dTAAAAFQAAAAAAAMSQRzACAAAA5jMJ"
    + "ShZDVkscKTVHRT5IQElKSUY6NSwvTEUndtPIIauoahVxwY0vx4aNnXZYsGqogKC+66/+gOZj/kPO"
    + "F9fKGIrF1o/Y4O2iGTXDiDek4Wt/Tp+Y6ueVR1fquvaYAXLWXZVXyI1RFGXzzoznm7tHHl97N/tz"
    + "2gfmm4O3i6d1UEO2erso3RD9577jRpfLfw63CUG8VVKNcgjx55e/CNcNzfORW9DW08qrRLIsoU1k"
    + "uWknwWUMmlqHjweTpQGQoTLMZ54nkm7+2X/osc+B+c6Sft0Yt45rpjwunclf1SiJPNnbHYaw/oGA"
    + "jBdgOmIK/VVmH991SPfywa9JSsMuki0Cmpq14ZcDOiCwAzgVGsCH3VELAAaIhk7xFs8HBZabGQPr"
    + "NEhmAjACB9lNEerpxsQRwcf76UwHAADwaNQRAJCgP4V9yC4TkpoZK6SqATAq8rjWEWH13y+Z2aiT"
    + "u3+BtIDeID/p9CFML7CL9WcM3E7iZd1whvJNEBlcrMSSmVXGS6MEXbD6C2ar5bf97FEnQZyIfyoB"
    + "gAV7F5/vl3WrmRSQnSkdjq5wJfl9EdxI2s4AYgBKjIL5efLLch1OZT75WhTdIJacVWZHG5LiLBoA"
    + "9crIvUNHLm3RTviZfqHlX8pYSxGhppoKAACA3s8K/93+HjIAQEuZvbbypqUE3oRK88EBcGpZhqAv"
    + "AZqaVbZXcyisTQOoMiByu++LO+ZMOHukABxKI1qzn2eABFhc9ubFDoCYKnGg2Qa0uEu9nclJj6Xp"
    + "uz60DlsDiphVxqoEAMyFs1ipbRSs0/Okf7xAe+zw/woWgA4ArT2W//L1sRgaAJZEz1EXil8l8yjK"
    + "mKgIABAt6bnwftYzh7e5e4ViuCoFgpgZ4148QIJ+AAQSA4hcDdnald1yhezdyI+uFgAAFKB4/xuX"
    + "H3YK4I2vB79/7o4EaRsDLgyGlcPz+Hb12u4NMYaWVfBNFkAHKJ2zKvhjozXNn16ZFkX65Z0iEAOA"
    + "7ifH6ZNb9aU1AFiYO+ajf/15MjzU9xANc2d2x7zzQ84VMoKkM+kaUCBLUwuClVVi6QMADwDnrEpD"
    + "0JBxsfr1stW2tyO7AAAAILIAQs8vhZ8qmGMGACxquZeXD5auTcbjFgUbIdiwwbTzh8kO1XAb4jah"
    + "2sTdM37VUOPhAXoA3AAA1KHbBOn23x7mmP5Qir0AAAAUBHBQiTWOyd2fP3vXIxWBklwKAPia7o+7"
    + "J5oFALSIzu0Lju49tC1fmaIxGCOC1DD8eAOINoDaQBa6pYf27piZL2P6kWntJMWbNBhlnh4AAEyb"
    + "f6nUowpARiClPNb4/u1iz/ZjrhmyeH9hzj+eM5bVmZ0AhpaZt81wheUJwAkGoSqHW9+/1+PFyVr/"
    + "S+kH1QIAAIDwicoAIND6yE9fRO2ABb/1gdoQQtLJIMo1AIqVVbrfNiQIFlYRaBVr1kFrnbP/Z08C"
    + "AIDS7smlIFVA93unKHyftVQo2tbMpVTfPcNQ6dEBhpZVskMDBmCMHBD3eZrZqyvR+utnmnfTCQAA"
    + "1ywAYLMIIHt00Bi4FaZiGwGClVXgoQQA3BZj5AAyzytL/fSCGR8fLV3rBADgfScA2MtLVAFjMd+Z"
    + "G36VsSZpAHrVkyCazAEbkaRSDGQozF/J7VvGJylTv/9TqwWkZer8zonYjISwx+UYCcLT4yibgz+9"
    + "eDK6NuPhc1TtmJOImL9y/aF9lqvq6llr4AGC1ZPpyxtw3OILxFz5gWfdV31n98eT8lQAAHCGXBCN"
    + "flHk6EM9i6P339uaUE64UWwZAxe0mKlNsbng4+XWbfjyqG8qyAmGlVXoS8NkBwhCQAW5ev7AfILb"
    + "ab+o3gAAiobC1krMfz7OTPfaQDVPZ2dTAAAAKwAAAAAAAMSQRzADAAAAojNpNhYyRkQvLDQsMzYs"
    + "KjBCSUZFSEdHRC9DgpWZt+kBBHpLAARmFSEEU6wu55NLbddM8dilMQoAACABgN4QikKmz227hQH4"
    + "SMXWxAx+1ZMg36yhsYCqqAyaJtbHad5uH7oY9bH9ce2zJQCA4CwtpVW4kL9+ybvF3ux5r1V9Op1d"
    + "TESszYn0XGTSKHcXHZPySEnMetaTQPzahgYkoPjiIQTJl+8/37pSH6X8aQIAQIIBzCh4UgV/Wuft"
    + "te442AJMmh+LgALf0M6lmWOK67KILZFnXPmV0wGGlVXGaXhOAACzBqeqs3Fnfqizsn2atjv7SAIA"
    + "AAAPNghVbZ2QhqHAqbNctdeBTYKVVfJf47gCmEGgEfdPH9efeuLPlhm3nwIAwBAnPAr0mQUrnFso"
    + "5FktPaoDglWtDk8NOiMBEJjBEYnm6ruP/TA5Pb029T1DFQAAACgID+brDsvOi5znozz2kJNgs9Xl"
    + "MoaVVeKmAUOhMUkKN8PJA3nn2WTP1hcff1QrEwAawAPYGxrhHQhy81CQLY5PfpUZY5oaOpsRmEHm"
    + "vtfycJzXdbL7I3z48GsHAICkFZ6nTYOpeBWTfTnRWV2tc1GC3kkBglStjk8NIACALRncaONt3Tvn"
    + "MfFj0/7/PQUAAADHyu7lzk7Zg7np3vUdUSVgtvo/whKz7rgDfpUZ435oCNaAGRxNGj0H9y+X7VrW"
    + "+N9fywEAUADYtzmThLzFunqPn6ZnxgOKlVXoqQQAZDVAIBdQg7i+m/pquCuy//PZAQCgC9qdl9db"
    + "+i3TxskeKRJ6lBkjPzQUJgIz4DpvMvQ5s11EP+WnN68nAAgA0HlReJhVVc9vcrIt5krmPUnRzAB2"
    + "1ZNg3qzxmAiVb+AtVrvbmbgtiS/3ds/PAICGaV6bOUGGGcnt3ji1HdO5WdnTIWZXvIIyM3kpHKkL"
    + "7yTiTWXakgV21ZNwbtaAYVS1L2TDV4kfy+Qq3dnhtjZ96wQAYB6wxQ4c4zz3i+Qk4UmzG08iYndw"
    + "aE/d5CxSkYV9QoGTrl0zSPVlw5HzkmoDctaTcLusgYcDxYIOTN5sv7S8mrnZ9uu0mADApog0iz7L"
    + "r+V20qk4tET2GrjPeXmLUUfLOKLNMaFNHGTfd1PYwZEhjeD7AnLVkwC+sSEoqIrSIdJaPW5dy6Nl"
    + "lbL96XUJANBFwxBAN9xAnJ8pRQsffVFFfcJ9qHKFXv6Ml2fg5s4XSy+bfFQ2GhHoAHLVkyCe1oAk"
    + "FHWKhpZ703zeSD0bL/uPTyp/SgAA3qOYiqWel/gOzp6waLKX4V8mvaaK3LVNE0hzxudvUry7Q66S"
    + "EE4HHtZyCm6VVU11WgNqWK0YSMW98ebatkRycvfB4eZkMQEAONR469c2F7Tl6TWJl1kIjtd1T1Kp"
    + "ajZFC5Mz1KfhL16wrD1u4ar+c3ARetWT50cPunsArPINqJgn/0v75faUdqp332ajAAAAwGOciIYc"
    + "Cm4V8+bYtzLOHyJqypvn0W8IFPES3bnzQ1AlZP1qC1k76gJ61JPnVw8AAKFWS+Ety9HpH6ej8eTa"
    + "rw8LAAAALCcpkWCWuLT9fJsH1Dp77Uhd0dImrS4pU4ct+EOzx3YSV0rDqpxCN36UmbdL4zsjACsC"
    + "XoRbk+mfjox2vN67AQBA8UnfBsNWVCReRuiLWvxQiiqS/Mo0etST4eYNGIgtvsAYzHxgnxjp0xkz"
    + "6lIAAND77FB0kbU4/74xNu8O/fKNty3xdPSMsFtgWHlBuGRfPlpZFTR5I3xQFU9nZ1MAAABBAAAA"
    + "AAAAxJBHMAQAAAD09EnxFkJGQ0BJRkdFSElNRkpHSUxJTUlISkl21ZNgPrwhgdUqA8UTKZdtpvcT"
    + "y+n5i+IpAAAUjpn6Lyae3smeq/ZdvdC92gQmlxGBiCR+34bI5H5n9cxsL+o0P9Zu1ZNgfzyHBFZ8"
    + "CzoX4/ClWcZBIrnx+fonAwDMyUt3zukMhmRyAeREVt++oNgZ9DbF5xW15URFrYKmHrnaLbKIEmyQ"
    + "bkUDdtWT4eE5oGE/GtBquby1b2UJ71dbn2cFAJ6jA7K9Et2uMkdYEPyyF6xBIkjN0PBEQboX8eYy"
    + "qqcIdNKqLDxLs117AHrWk/A+vAQARIEtikAK1OK76yKJen/X+7GQAABoGsDenqPu+MPM5lqb+9Jd"
    + "R53VAi2+Sc9typz9pGFKPPdm5x5y1JNwbsxxyo1RFd9wd2T4GfZ/GBM/Zz9+XlYB4GhzG+Z/DHUh"
    + "wdclFoUz8atvdZb1H21ls3wbKuXg1gHy2cqVeD0LOWG5eDMzctWTMLaxAQ3VKhrO0JK6fa/tmNo7"
    + "H35+BwDQ7PZZ/GDQqx42RB573hOVtjBQwKF7JMrmZpfdPEXr24mtbx8xG5NX3XKvB3LVk5AfNigE"
    + "ACJaDfClVi/+lZ1kn5XtxJ+sAAAAYEbc/ESaXCCr3PttAYA/CVfMjahYcG3RrxFHhlXsy5Zdqirg"
    + "eV6mS3cEbtWTs8cbClB930Jugj74K3XeXU56e57eBABAeDxG/Gpiqe7CUM4D2msSOD+zWDO/Ec6s"
    + "0tYUP1C1Snmza6BxetbQDhQObtWT4WUNWIRQAkuFs1ENP4bLO6vRk77/z88AAPBehPvTI/1zhz+a"
    + "yTcDofPEbgy0SX49flkBTlKfvM1Y5BY1d9xFlAvHPjQ1ctOQ7NtLAMAtUK2KAiGWHBoZKu3z3yXj"
    + "ZDUBALAH0yTSEUpnde889MNZR5irA6yy7nmF+qA53DAsty45c3Z8iXrKtKq9sIYlAHLWk3BuNpjc"
    + "BBAqVQcNtdqd+G1zMHp6sfwepQsoAACAicOm39XC5mFJy/K+75VqcvRcMbJaKBt5Zc7MnT1VX9+q"
    + "dtVs5yzPeTJvVW4DctWTUF9s4GFFMSiPLi9ervfsyRev2NxvDQAk+jUuH86iJr6+oAOlaugn9Ltl"
    + "SChRs1/6EPs0fr3LpnHrkAz/6v4FXYy5zHLVkxCnNfBQnd8BdzlfXRqGoXs3zQN/HpkAQCsu8yGx"
    + "XyZjOYvH3DuPkMWt61ITcs7iZDG9jAMRD654Oa6CNAfTvs7HkmtxdNYHctWQtJ838ASVb+BNYkjz"
    + "zz+HTD7+TP9uAAAQhV/c1UJUNHf2nB1lG3kaNkt3n2c1uVmq3HoXuUmJs1Fs8nQtihkS1sMbrRZ2"
    + "1VDyzQ18oKqVDpThN+aWY5OTJ1+YEzdvB4CEjm8/tH8k27QSeN8b5RpdMkQgRiyksKs2NztRwxVx"
    + "zjdncqZrJaYFmaMnqbIBctRQ8k2NT5Jq8Q3oSPYvHuqzvtfqgUtTTicAGlyOdfuQJ++AtjF9ziOP"
    + "YaPt9OlxjGmyWBXHQupAELYAeBexhanByFF7eZp1F0l5c3LVUPb5BuxRFcWgqnnqWeycWbtPnn45"
    + "kQkACGWf7lJxSrF2Z5KjQikfs3GbTdoJmToCG5vjDr5xc/5uY1C4BY+O9UWJRr3UWgVy1VDvQzmg"
    + "M1KiUQFT92a0mcaK4e34aLwjZUqKLSgNxV7KsQ+xER3RMoh9tpg7VX5ylsktMpMGv+tqhSW5Yd9e"
    + "vM1TXR5PZqsq4HcnAHbVULrnA1GlCqFwLQRk+ceIlgv295MAALX6BKflQ050rQmZ89wJxseW3Vb7"
    + "zTT3TMTWxzH6Y+Lb+EcmLJjsldPioVrH12Hw0ABy1VDawzmgoyoWg4i7cf53teyPnx6++qJXAjRm"
    + "cc/2AB1n3yx4F7XU4O/ixPe8vgVauBotjiruezlGZhyqveU9VO+hTC6lfgVy1JC0DzckC6hqi0GR"
    + "JfnuWprTie7o6875+wkAYFayR9PsQWiaK+truDnC5WsXVGAhtKwNDkJxPcf6is2Ce1/lnLOyaN2i"
    + "Ee/MAXbWkzDf4YMKCgC5UxsQJezm/3dUQvju+ecEAAAAwMwTUr4AfmCD2qvu0eRFaVzlkTmrXyJ2"
    + "Tuqjk80ESwvovpBGLXZsM6SCBGJPZ2dTAAQAWAAAAAAAAMSQRzAFAAAA7wLV3hdLRUlJSUlIR01N"
    + "R0hITUhFRUlLSUhUDXLVkzB+cDgAQK5SDIju1icTfW/cfJ8PHppQBQAAAFvVFR1RYGBYI0Mldyq+"
    + "ZX7fn8xzKdQ5pzpmIf0VH6Ubd2DjlW2wgWfTuQOrAHLVkLSv54AiWCwGXqqb3dnshMRNulmDC4gQ"
    + "DDR70Pb+i7lXvdPnHXNHf65NXZ8XtcBqzNaVm1qcnL9m0SRTn62188TGAXLVkzB+sCEZSagVA+ZZ"
    + "dkd2D07G1t02dTxNAADvfFRaH2oQN3WDyh6SrMe+pH/CXMJi1T404hB+vJl+sHdPPg8yWIPgotHn"
    + "egdy1JC0LzeghmrxDapCDb3nZ1MtPD08yysAcAjv4HRpW8tk+6DP49gUcz/OO5vwh8NPZSgf/rA6"
    + "Lgsh8iC4SOpA8IiSOVhw+0kBctaT1Rsb+MJiURkI0euf73fj5PzW1j63T2cAMPOcX2WryFH2u/DN"
    + "9CYeXPpRz+ojLQ99wRHuETOywo7OPVajZBY24qxAMbrtDHLVUNrzDUBVAgN3DRPJbk2Z8fxk+1+n"
    + "AYAMwsxrhTqW0u/RNR9Wte+mu5lxccLfRIaClNrBEIoaJH/NdAvJdBXiXtfFzccsdQNy1VDa0w2F"
    + "Y/UVAw+R+ZW/NydrPn7//3cDgBhbEe1kTqIIKYhXpnJo1zEkVa7XTpTMVsyfwmXga9vTXYH3RQ4c"
    + "Mk1DbT1ufD121VDfTTlgIIMfGBTu4C7m+GYIIwHQrrhIGT0PNh9WLAJxYtbOSYQsioXNf7vW7f6E"
    + "1p7orgJFXLvLVxkZ6Uul2R5szFe7AXLVUO+qARcJUBTfoJohra1bLMnl2XRvuhUAAACQ3AAcC98/"
    + "OO3xEBHhW7vPibqXXCLadv4RZB/UmuMNcYYacUxNHJWb2B0l1JXTRCZEdtVQvrsbMJJVFRig4uHT"
    + "dPfpMkwfmfjvegKAeEI65w8WCzJozUSBWQ5Lgh7ZlXkjkek85rOi+97TLAcxKTLJFw/gwBDwtmS6"
    + "2osRMQNy1VDuzQ0YJleigYc8sLp92hKNbH1y1gAACBGvtDTe1bR0usEq5zaTxBxZOvFr+VlubATa"
    + "vDKr8zy12oLYnHNGAj99+OyYkHrVML/pELBNBkUl4MAUY5uEd74+9PmAonLq+X99vLFB40bijNKc"
    + "TLuGLWs6POPWUkZRJhMBk72fzymUYULzcNV9FO76WIXvA3LWUN9NDaDIfIMids3bk30PYrz92Yh3"
    + "AGiNMQxIw81reHdsFAUorc6hxmRFEh7Edb/rLkf+xEZJBzPyjHOzO6sT3AeOo4laAXaW1X23BDaA"
    + "orLXJVngghKrKQENw/O9SLrZp/r4PAsAJINzUV96T2XxNtFg+mNGRNN8uTv0JrN/uKxR9ZIVrz/G"
    + "3vrPkVsX5uJi3O4LdpbVvqs5cJ1BUQRXOOnzikFy8uf67+ezBCahSGUyjZy8UlVtgUJNSd/Yv/4L"
    + "j2dwBbx3T8ZSXJ6+RUj/gtlh6H3X9wBEK0QSdtaw3yVPVrWKoCjO6emHrq71+jwAsNJpsnobTrlh"
    + "CFEalDK97RnVGhPlZCAqI0F0HozVGMvlYbbzQEGdftvavK9tsy4udpXVfrd6siqRkAZ1dRQ6v/P5"
    + "60U/AK5Z0BXrZm/igClPCMKjvO6kq/olArlliWY7/MJHkLKzpCT28igFluzQSvJL2bRGdpbV987m"
    + "gKlSKQIoJTnkCicz0lxeBAAuAFth8e6JnD75Fas29yw6m0C7Pz7hYdpe27T0PJROCm0l5484hf6W"
    + "Erd3ljqo0+ieAnaWGcdSGjDQqRQBgLHmisvJRtXvBsAG6FGz8x7nj/NkjBzfD917cRTuIsk+qD6B"
    + "j6qy3dttrqwjR0wGRbGcTaTDqvzzBxNHvRIJA3KWGXepDaBm5AOAEpSBx55fN44AAGKVG/kv1lXc"
    + "pfaSuHSuCMXiqDlSqCtJp9syH+dvNZdcUau7HIQVpWZOg7nlFNqMXrDF5gFy1ZBiWZKKygd0HSLn"
    + "36f8YsCb3+KMo7SrGq1a/aW9t9Rh8KtJUtx9+2g03GOv1+7H0afWvn5EtWAk0pZrki+zCbmkTatX"
    + "egBy1cO+vysEFJUPAGtPtj6YPDDX8vD9wiokJU0d6iRSIkqnpDf2SUzw9qO9dVzmlBTKQOWX2vx+"
    + "eZ7x9eJ++YqM7Idt0GnOy6lcicI+NHByLV5/xRh2CO8CgMA4AOC7PAEA";

Cheetah.initialize = function () {
    "use strict";
    Cheetah.state.initialize();
    Cheetah.debug.initialize();
    Cheetah.count.initialize();
    Cheetah.ui.initialize();

    return true;
};

Cheetah.run = (function () {
    "use strict";
    Cheetah.initialize();
    Game.Logic = Cheetah.logic;
    Game.LoadSave = Cheetah.loadSave;
    Game.customSave.push(Cheetah.save);
    Game.customLoad.push(Cheetah.load);
    Cheetah.load();

    return "Cheetah running";
}());
